/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.registry;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.dataflow.core.ApplicationType;
import org.springframework.cloud.dataflow.registry.AppRegistration;
import org.springframework.cloud.dataflow.registry.support.NoSuchAppRegistrationException;
import org.springframework.cloud.deployer.resource.registry.UriRegistry;
import org.springframework.cloud.deployer.resource.registry.UriRegistryPopulator;
import org.springframework.core.io.ResourceLoader;

public class AppRegistry {
    private final UriRegistry uriRegistry;
    private final UriRegistryPopulator uriRegistryPopulator;
    private final ResourceLoader resourceLoader;

    public AppRegistry(UriRegistry uriRegistry, ResourceLoader resourceLoader) {
        this.uriRegistry = uriRegistry;
        this.uriRegistryPopulator = new UriRegistryPopulator();
        this.uriRegistryPopulator.setResourceLoader(resourceLoader);
        this.resourceLoader = resourceLoader;
    }

    public AppRegistration find(String name, ApplicationType type) {
        try {
            URI uri = this.uriRegistry.find(this.key(name, type));
            return new AppRegistration(name, type, uri, this.resourceLoader);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public List<AppRegistration> findAll() {
        ArrayList<AppRegistration> apps = new ArrayList<AppRegistration>();
        for (Map.Entry entry : this.uriRegistry.findAll().entrySet()) {
            apps.add(this.createAppRegistration((String)entry.getKey(), (URI)entry.getValue()));
        }
        return apps;
    }

    public AppRegistration save(String name, ApplicationType type, URI uri) {
        this.uriRegistry.register(this.key(name, type), uri);
        return new AppRegistration(name, type, uri, this.resourceLoader);
    }

    public List<AppRegistration> importAll(boolean overwrite, String ... resourceUris) {
        ArrayList<AppRegistration> apps = new ArrayList<AppRegistration>();
        Map registered = this.uriRegistryPopulator.populateRegistry(overwrite, this.uriRegistry, resourceUris);
        for (Map.Entry entry : registered.entrySet()) {
            apps.add(this.createAppRegistration((String)entry.getKey(), (URI)entry.getValue()));
        }
        return apps;
    }

    public void delete(String name, ApplicationType type) {
        if (this.find(name, type) == null) {
            throw new NoSuchAppRegistrationException(name, type);
        }
        this.uriRegistry.unregister(this.key(name, type));
    }

    private String key(String name, ApplicationType type) {
        return String.format("%s.%s", type, name);
    }

    private AppRegistration createAppRegistration(String key, URI uri) {
        String[] tokens = key.split("\\.", 2);
        return new AppRegistration(tokens[1], ApplicationType.valueOf((String)tokens[0]), uri, this.resourceLoader);
    }
}

