/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.registry;

import java.net.URI;
import org.springframework.cloud.dataflow.core.ApplicationType;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;

public class AppRegistration
implements Comparable<AppRegistration> {
    private final String name;
    private final ApplicationType type;
    private final URI uri;
    private final ResourceLoader loader;
    private volatile Resource resource;

    public AppRegistration(String name, ApplicationType type, URI uri, ResourceLoader loader) {
        Assert.hasText((String)name, (String)"name is required");
        Assert.notNull((Object)type, (String)"type is required");
        Assert.notNull((Object)uri, (String)"uri is required");
        Assert.notNull((Object)loader, (String)"ResourceLoader must not be null");
        this.name = name;
        this.type = type;
        this.uri = uri;
        this.loader = loader;
    }

    public String getName() {
        return this.name;
    }

    public ApplicationType getType() {
        return this.type;
    }

    public URI getUri() {
        return this.uri;
    }

    public Resource getResource() {
        if (this.resource == null) {
            this.resource = this.loader.getResource(this.uri.toString());
        }
        return this.resource;
    }

    public String toString() {
        return "AppRegistration{name='" + this.name + '\'' + ", type='" + this.type + '\'' + ", uri=" + this.uri + '}';
    }

    @Override
    public int compareTo(AppRegistration that) {
        int i = this.type.compareTo((Enum)that.type);
        if (i == 0) {
            i = this.name.compareTo(that.name);
        }
        return i;
    }
}

