/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.container.registry.authorization;

import java.net.URI;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.protocol.HttpContext;

public class DropAuthorizationHeaderRequestRedirectStrategy
extends DefaultRedirectStrategy {
    private static final String AMZ_CREDENTIAL = "X-Amz-Credential";
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String AZURECR_URI_SUFFIX = "azurecr.io";
    private static final String BASIC_AUTH = "Basic";

    public HttpUriRequest getRedirect(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
        String method;
        HttpUriRequest httpUriRequest = super.getRedirect(request, response, context);
        String query = httpUriRequest.getURI().getQuery();
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{query}) && query.contains(AMZ_CREDENTIAL) && StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{method = request.getRequestLine().getMethod()}) && (method.equalsIgnoreCase("HEAD") || method.equalsIgnoreCase("GET"))) {
            return new DropAuthorizationHeaderHttpRequestBase(httpUriRequest.getURI(), method);
        }
        if (request.getRequestLine().getUri().contains(AZURECR_URI_SUFFIX) && StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{method = request.getRequestLine().getMethod()}) && (method.equalsIgnoreCase("HEAD") || method.equalsIgnoreCase("GET"))) {
            return new DropAuthorizationHeaderHttpRequestBase(httpUriRequest.getURI(), method){

                @Override
                protected boolean isDropHeader(String name, String value) {
                    return name.equalsIgnoreCase(DropAuthorizationHeaderRequestRedirectStrategy.AUTHORIZATION_HEADER) && StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{value}) && value.contains(DropAuthorizationHeaderRequestRedirectStrategy.BASIC_AUTH);
                }
            };
        }
        return httpUriRequest;
    }

    static class DropAuthorizationHeaderHttpRequestBase
    extends HttpRequestBase {
        private final String method;

        DropAuthorizationHeaderHttpRequestBase(URI uri, String method) {
            this.setURI(uri);
            this.method = method;
        }

        public String getMethod() {
            return this.method;
        }

        public void addHeader(Header header) {
            if (!this.isDropHeader(header)) {
                super.addHeader(header);
            }
        }

        public void addHeader(String name, String value) {
            if (!this.isDropHeader(name, value)) {
                super.addHeader(name, value);
            }
        }

        public void setHeader(Header header) {
            if (!this.isDropHeader(header)) {
                super.setHeader(header);
            }
        }

        public void setHeader(String name, String value) {
            if (!this.isDropHeader(name, value)) {
                super.setHeader(name, value);
            }
        }

        public void setHeaders(Header[] headers) {
            Header[] filteredHeaders = (Header[])Arrays.stream(headers).filter(header -> !this.isDropHeader((Header)header)).toArray(Header[]::new);
            super.setHeaders(filteredHeaders);
        }

        protected boolean isDropHeader(Header header) {
            return this.isDropHeader(header.getName(), header.getValue());
        }

        protected boolean isDropHeader(String name, String value) {
            return name.equalsIgnoreCase(DropAuthorizationHeaderRequestRedirectStrategy.AUTHORIZATION_HEADER);
        }
    }
}

