/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.container.registry.authorization;

import java.util.Map;
import org.springframework.cloud.dataflow.container.registry.ContainerImage;
import org.springframework.cloud.dataflow.container.registry.ContainerImageRestTemplateFactory;
import org.springframework.cloud.dataflow.container.registry.ContainerRegistryConfiguration;
import org.springframework.cloud.dataflow.container.registry.authorization.RegistryAuthorizer;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class DockerOAuth2RegistryAuthorizer
implements RegistryAuthorizer {
    public static final String DEFAULT_DOCKER_REGISTRY_AUTH_URI = "https://auth.docker.io/token?service=registry.docker.io&scope=repository:{repository}:pull&offline_token=1&client_id=shell";
    public static final String TOKEN_KEY = "token";
    public static final String DOCKER_REGISTRY_AUTH_URI_KEY = "registryAuthUri";
    public static final String DOCKER_REGISTRY_REPOSITORY_FIELD_KEY = "repository";
    private final ContainerImageRestTemplateFactory containerImageRestTemplate;

    public DockerOAuth2RegistryAuthorizer(ContainerImageRestTemplateFactory containerImageRestTemplate) {
        Assert.notNull((Object)containerImageRestTemplate, (String)"Non null containerImageRestTemplate is expected!");
        this.containerImageRestTemplate = containerImageRestTemplate;
    }

    @Override
    public ContainerRegistryConfiguration.AuthorizationType getType() {
        return ContainerRegistryConfiguration.AuthorizationType.dockeroauth2;
    }

    @Override
    public HttpHeaders getAuthorizationHeaders(ContainerRegistryConfiguration registryConfiguration, Map<String, String> configProperties) {
        Assert.isTrue((registryConfiguration.getAuthorizationType() == this.getType() ? 1 : 0) != 0, (String)("Incorrect authorization type: " + (Object)((Object)registryConfiguration.getAuthorizationType())));
        HttpHeaders requestHttpHeaders = new HttpHeaders();
        if (StringUtils.hasText((String)registryConfiguration.getUser()) && StringUtils.hasText((String)registryConfiguration.getSecret())) {
            requestHttpHeaders.setBasicAuth(registryConfiguration.getUser(), registryConfiguration.getSecret());
        }
        UriComponents uriComponents = UriComponentsBuilder.fromHttpUrl((String)registryConfiguration.getExtra().getOrDefault(DOCKER_REGISTRY_AUTH_URI_KEY, DEFAULT_DOCKER_REGISTRY_AUTH_URI)).build().expand(new Object[]{configProperties.get(DOCKER_REGISTRY_REPOSITORY_FIELD_KEY)});
        HttpHeaders responseHttpHeaders = new HttpHeaders();
        ResponseEntity authorization = this.getRestTemplate(registryConfiguration).exchange(uriComponents.toUri(), HttpMethod.GET, new HttpEntity((MultiValueMap)requestHttpHeaders), Map.class);
        if (authorization != null) {
            Map authorizationBody = (Map)authorization.getBody();
            responseHttpHeaders.setBearerAuth((String)authorizationBody.get(TOKEN_KEY));
        }
        return responseHttpHeaders;
    }

    @Override
    public HttpHeaders getAuthorizationHeaders(ContainerImage containerImage, ContainerRegistryConfiguration registryConfiguration) {
        Assert.isTrue((registryConfiguration.getAuthorizationType() == this.getType() ? 1 : 0) != 0, (String)("Incorrect authorization type: " + (Object)((Object)registryConfiguration.getAuthorizationType())));
        Assert.notNull((Object)containerImage, (String)"Valid containerImageName is required!");
        String imageRepository = containerImage.getRepository();
        Assert.hasText((String)imageRepository, (String)"Valid repository name (e.g. namespace/repository-name without the tag) is required for the authorization");
        HttpHeaders requestHttpHeaders = new HttpHeaders();
        if (StringUtils.hasText((String)registryConfiguration.getUser()) && StringUtils.hasText((String)registryConfiguration.getSecret())) {
            requestHttpHeaders.setBasicAuth(registryConfiguration.getUser(), registryConfiguration.getSecret());
        }
        String registryAuthUri = registryConfiguration.getExtra().getOrDefault(DOCKER_REGISTRY_AUTH_URI_KEY, DEFAULT_DOCKER_REGISTRY_AUTH_URI);
        UriComponents uriComponents = UriComponentsBuilder.fromHttpUrl((String)registryAuthUri).build().expand(new Object[]{imageRepository});
        HttpHeaders responseHttpHeaders = new HttpHeaders();
        ResponseEntity authorization = this.getRestTemplate(registryConfiguration).exchange(uriComponents.toUri(), HttpMethod.GET, new HttpEntity((MultiValueMap)requestHttpHeaders), Map.class);
        if (authorization != null) {
            Map authorizationBody = (Map)authorization.getBody();
            responseHttpHeaders.setBearerAuth((String)authorizationBody.get(TOKEN_KEY));
        }
        return responseHttpHeaders;
    }

    private RestTemplate getRestTemplate(ContainerRegistryConfiguration registryConfiguration) {
        return this.containerImageRestTemplate.getContainerRestTemplate(registryConfiguration.isDisableSslVerification(), registryConfiguration.isUseHttpProxy());
    }
}

