/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.container.registry.authorization;

import java.util.Map;
import org.springframework.cloud.dataflow.container.registry.ContainerImage;
import org.springframework.cloud.dataflow.container.registry.ContainerRegistryConfiguration;
import org.springframework.cloud.dataflow.container.registry.authorization.RegistryAuthorizer;
import org.springframework.http.HttpHeaders;
import org.springframework.util.Assert;

public class BasicAuthRegistryAuthorizer
implements RegistryAuthorizer {
    @Override
    public ContainerRegistryConfiguration.AuthorizationType getType() {
        return ContainerRegistryConfiguration.AuthorizationType.basicauth;
    }

    @Override
    public HttpHeaders getAuthorizationHeaders(ContainerRegistryConfiguration registryConfiguration, Map<String, String> configProperties) {
        Assert.isTrue((registryConfiguration.getAuthorizationType() == this.getType() ? 1 : 0) != 0, (String)("Incorrect type: " + (Object)((Object)registryConfiguration.getAuthorizationType())));
        HttpHeaders headers = new HttpHeaders();
        headers.setBasicAuth(registryConfiguration.getUser(), registryConfiguration.getSecret());
        return headers;
    }

    @Override
    public HttpHeaders getAuthorizationHeaders(ContainerImage containerImage, ContainerRegistryConfiguration registryConfiguration) {
        return this.getAuthorizationHeaders(registryConfiguration, null);
    }
}

