/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.container.registry;

import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.dataflow.container.registry.ContainerRegistryConfiguration;
import org.springframework.util.StringUtils;

@ConfigurationProperties(prefix="spring.cloud.dataflow.container")
public class ContainerRegistryProperties {
    public static final String CONTAINER_IMAGE_METADATA_PREFIX = "spring.cloud.dataflow.container";
    public static final String OCI_IMAGE_MANIFEST_MEDIA_TYPE = "application/vnd.oci.image.manifest.v1+json";
    public static final String DOCKER_IMAGE_MANIFEST_MEDIA_TYPE = "application/vnd.docker.distribution.manifest.v2+json";
    public static final String DOCKER_HUB_HOST = "registry-1.docker.io";
    public static final String DEFAULT_TAG = "latest";
    public static final String DEFAULT_OFFICIAL_REPO_NAMESPACE = "library";
    private String defaultRegistryHost = "registry-1.docker.io";
    private String defaultRepositoryTag = "latest";
    private String officialRepositoryNamespace = "library";
    private Map<String, ContainerRegistryConfiguration> registryConfigurations = new HashMap<String, ContainerRegistryConfiguration>();
    private HttpProxy httpProxy = new HttpProxy();
    private boolean replaceDefaultDockerRegistryServer = true;

    public HttpProxy getHttpProxy() {
        return this.httpProxy;
    }

    public Map<String, ContainerRegistryConfiguration> getRegistryConfigurations() {
        return this.registryConfigurations;
    }

    public void setRegistryConfigurations(Map<String, ContainerRegistryConfiguration> registryConfigurations) {
        this.registryConfigurations = registryConfigurations;
    }

    public String getDefaultRegistryHost() {
        return this.defaultRegistryHost;
    }

    public void setDefaultRegistryHost(String defaultRegistryHost) {
        this.defaultRegistryHost = defaultRegistryHost;
    }

    public String getDefaultRepositoryTag() {
        return this.defaultRepositoryTag;
    }

    public void setDefaultRepositoryTag(String defaultRepositoryTag) {
        this.defaultRepositoryTag = defaultRepositoryTag;
    }

    public String getOfficialRepositoryNamespace() {
        return this.officialRepositoryNamespace;
    }

    public void setOfficialRepositoryNamespace(String officialRepositoryNamespace) {
        this.officialRepositoryNamespace = officialRepositoryNamespace;
    }

    public boolean isReplaceDefaultDockerRegistryServer() {
        return this.replaceDefaultDockerRegistryServer;
    }

    public void setReplaceDefaultDockerRegistryServer(boolean replaceDefaultDockerRegistryServer) {
        this.replaceDefaultDockerRegistryServer = replaceDefaultDockerRegistryServer;
    }

    public String toString() {
        return "ContainerRegistryProperties{defaultRegistryHost='" + this.defaultRegistryHost + '\'' + ", defaultRepositoryTag='" + this.defaultRepositoryTag + '\'' + ", officialRepositoryNamespace='" + this.officialRepositoryNamespace + '\'' + ", registryConfigurations=" + this.registryConfigurations + '}';
    }

    public static class HttpProxy {
        private String host = "";
        private int port = 0;

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public boolean isEnabled() {
            return StringUtils.hasText((String)this.host);
        }
    }
}

