/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.composedtaskrunner;

import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.dataflow.schema.SchemaVersionTarget;
import org.springframework.cloud.task.repository.TaskExplorer;

public class TaskExplorerContainer {
    private static final Logger logger = LoggerFactory.getLogger(TaskExplorerContainer.class);
    private final Map<String, TaskExplorer> taskExplorers;
    private final TaskExplorer defaultTaskExplorer;

    public TaskExplorerContainer(Map<String, TaskExplorer> taskExplorers, TaskExplorer defaultTaskExplorer) {
        this.taskExplorers = taskExplorers;
        this.defaultTaskExplorer = defaultTaskExplorer;
    }

    public TaskExplorer get(String name) {
        TaskExplorer result = (TaskExplorer)this.taskExplorers.get(name);
        if (result == null) {
            result = (TaskExplorer)this.taskExplorers.get(SchemaVersionTarget.defaultTarget().getName());
        }
        if (result == null) {
            logger.warn("Cannot find TaskExplorer for {}. Using default", (Object)name);
            result = this.defaultTaskExplorer;
        }
        return result;
    }

    public Set<String> getKeys() {
        return this.taskExplorers.keySet();
    }
}

