/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.composedtaskrunner;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.listener.StepExecutionListenerSupport;
import org.springframework.cloud.dataflow.composedtaskrunner.TaskExplorerContainer;
import org.springframework.cloud.task.repository.TaskExecution;
import org.springframework.cloud.task.repository.TaskExplorer;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ComposedTaskStepExecutionListener
extends StepExecutionListenerSupport {
    private static final Logger logger = LoggerFactory.getLogger(ComposedTaskStepExecutionListener.class);
    private final TaskExplorerContainer taskExplorerContainer;

    public ComposedTaskStepExecutionListener(TaskExplorerContainer taskExplorerContainer) {
        Assert.notNull((Object)taskExplorerContainer, (String)"taskExplorerContainer must not be null.");
        this.taskExplorerContainer = taskExplorerContainer;
        logger.info("ComposedTaskStepExecutionListener supporting {}", (Object)taskExplorerContainer.getKeys());
    }

    public ExitStatus afterStep(StepExecution stepExecution) {
        logger.info("AfterStep processing for stepExecution {}:{}", (Object)stepExecution.getStepName(), (Object)stepExecution.getJobExecutionId());
        ExitStatus result = ExitStatus.COMPLETED;
        Long executionId = (Long)stepExecution.getExecutionContext().get("task-execution-id");
        Assert.notNull((Object)executionId, (String)("TaskLauncherTasklet for job " + stepExecution.getJobExecutionId() + " did not return a task-execution-id. Check to see if task exists."));
        String schemaTarget = stepExecution.getExecutionContext().getString("schema-target");
        String taskName = stepExecution.getExecutionContext().getString("task-name");
        Assert.notNull((Object)taskName, (String)("TaskLauncherTasklet for job " + stepExecution.getJobExecutionId() + " did not return a task-name. Check to see if task exists."));
        String explorerName = taskName;
        if (!this.taskExplorerContainer.getKeys().contains(taskName)) {
            Assert.notNull((Object)schemaTarget, (String)("TaskLauncherTasklet for job " + stepExecution.getJobExecutionId() + " did not return a schema-target. Check to see if task exists."));
            explorerName = schemaTarget;
        }
        logger.info("AfterStep for {}:{}:{}:{}:{}", new Object[]{stepExecution.getStepName(), stepExecution.getJobExecutionId(), taskName, executionId, schemaTarget});
        TaskExplorer taskExplorer = this.taskExplorerContainer.get(explorerName);
        TaskExecution resultExecution = taskExplorer.getTaskExecution(executionId.longValue());
        if (!stepExecution.getExecutionContext().containsKey("IGNORE_EXIT_MESSAGE") && StringUtils.hasText((String)resultExecution.getExitMessage())) {
            result = new ExitStatus(resultExecution.getExitMessage());
        } else if (resultExecution.getExitCode() != 0) {
            result = ExitStatus.FAILED;
        }
        logger.info("AfterStep processing complete for stepExecution {} with taskExecution {}:{}:{}:{}", new Object[]{stepExecution.getStepName(), stepExecution.getJobExecutionId(), taskName, executionId, schemaTarget});
        return result;
    }

    public void beforeStep(StepExecution stepExecution) {
        logger.info("beforeStep:{}:{}>>>>", (Object)stepExecution.getStepName(), (Object)stepExecution.getJobExecutionId());
        super.beforeStep(stepExecution);
        logger.debug("beforeStep:{}", (Object)stepExecution.getExecutionContext());
        logger.info("beforeStep:{}:{}<<<", (Object)stepExecution.getStepName(), (Object)stepExecution.getJobExecutionId());
    }
}

