/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.completion;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.springframework.cloud.dataflow.completion.CompletionProposal;
import org.springframework.cloud.dataflow.completion.CompletionUtils;
import org.springframework.cloud.dataflow.completion.ProposalsCollectorSupportUtils;
import org.springframework.cloud.dataflow.completion.StacktraceFingerprintingRecoveryStrategy;
import org.springframework.cloud.dataflow.configuration.metadata.ApplicationConfigurationMetadataResolver;
import org.springframework.cloud.dataflow.core.AppRegistration;
import org.springframework.cloud.dataflow.core.StreamAppDefinition;
import org.springframework.cloud.dataflow.core.StreamDefinition;
import org.springframework.cloud.dataflow.core.StreamDefinitionService;
import org.springframework.cloud.dataflow.core.StreamDefinitionServiceUtils;
import org.springframework.cloud.dataflow.core.dsl.CheckPointedParseException;
import org.springframework.cloud.dataflow.registry.service.AppRegistryService;

public class UnfinishedConfigurationPropertyNameRecoveryStrategy
extends StacktraceFingerprintingRecoveryStrategy<CheckPointedParseException> {
    private final ProposalsCollectorSupportUtils collectorSupport;

    UnfinishedConfigurationPropertyNameRecoveryStrategy(AppRegistryService appRegistry, ApplicationConfigurationMetadataResolver metadataResolver, StreamDefinitionService streamDefinitionService) {
        super(CheckPointedParseException.class, streamDefinitionService, "file --foo", "file | bar --quick", "file --foo.", "file | bar --quick.");
        this.collectorSupport = new ProposalsCollectorSupportUtils(appRegistry, metadataResolver);
    }

    @Override
    public void addProposals(String dsl, CheckPointedParseException exception, int detailLevel, List<CompletionProposal> collector) {
        String safe = exception.getExpressionStringUntilCheckpoint();
        StreamDefinition streamDefinition = new StreamDefinition("__dummy", safe);
        LinkedList streamAppDefinitions = this.streamDefinitionService.getAppDefinitions(streamDefinition);
        StreamAppDefinition lastApp = (StreamAppDefinition)StreamDefinitionServiceUtils.getDeploymentOrderIterator((LinkedList)streamAppDefinitions).next();
        AppRegistration appRegistration = this.collectorSupport.findAppRegistration(lastApp.getName(), CompletionUtils.determinePotentialTypes(lastApp, streamAppDefinitions.size() > 1));
        if (appRegistration != null) {
            String startsWith = ProposalsCollectorSupportUtils.computeStartsWith(exception);
            HashSet<String> alreadyPresentOptions = new HashSet<String>(lastApp.getProperties().keySet());
            this.collectorSupport.addPropertiesProposals(safe, startsWith, appRegistration, alreadyPresentOptions, collector, detailLevel);
        }
    }
}

