/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.completion;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataProperty;
import org.springframework.cloud.dataflow.core.ApplicationType;
import org.springframework.cloud.dataflow.core.StreamAppDefinition;
import org.springframework.cloud.dataflow.core.StreamDefinition;

public class CompletionUtils {
    static final Set<String> IMPLICIT_PARAMETER_NAMES = new HashSet<String>();
    static final Set<String> IMPLICIT_TASK_PARAMETER_NAMES = new HashSet<String>();

    static ApplicationType[] determinePotentialTypes(StreamAppDefinition appDefinition, boolean multipleAppsInStreamDefinition) {
        Set properties = appDefinition.getProperties().keySet();
        if (properties.contains("spring.cloud.stream.bindings.input.destination")) {
            if (properties.contains("spring.cloud.stream.bindings.output.destination")) {
                return new ApplicationType[]{ApplicationType.processor};
            }
            return new ApplicationType[]{ApplicationType.processor, ApplicationType.sink};
        }
        if (multipleAppsInStreamDefinition) {
            return new ApplicationType[]{ApplicationType.app};
        }
        return new ApplicationType[]{ApplicationType.source, ApplicationType.app};
    }

    static String maybeQualifyWithLabel(String appName, StreamDefinition streamDefinition) {
        String candidate = appName;
        HashSet<String> alreadyUsed = new HashSet<String>();
        for (StreamAppDefinition appDefinition : streamDefinition.getAppDefinitions()) {
            alreadyUsed.add(appDefinition.getName());
        }
        String result = candidate;
        int counter = 2;
        while (alreadyUsed.contains(candidate)) {
            candidate = appName + counter++;
            result = String.format("%s: %s", candidate, appName);
        }
        return result;
    }

    static boolean isMatchingProperty(String propertyName, ConfigurationMetadataProperty property, List<ConfigurationMetadataProperty> whiteListedProps) {
        if (property.getId().equals(propertyName)) {
            return true;
        }
        for (ConfigurationMetadataProperty white : whiteListedProps) {
            if (!property.getId().equals(white.getId())) continue;
            return property.getName().equals(propertyName);
        }
        return false;
    }

    static {
        IMPLICIT_PARAMETER_NAMES.add("spring.cloud.stream.bindings.input.destination");
        IMPLICIT_PARAMETER_NAMES.add("spring.cloud.stream.bindings.input.group");
        IMPLICIT_PARAMETER_NAMES.add("spring.cloud.stream.bindings.output.producer.requiredGroups");
        IMPLICIT_PARAMETER_NAMES.add("spring.cloud.stream.bindings.output.destination");
        IMPLICIT_TASK_PARAMETER_NAMES.add("spring.cloud.task.name");
    }
}

