/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.completion;

import java.util.HashSet;
import java.util.List;
import org.springframework.cloud.dataflow.completion.CompletionProposal;
import org.springframework.cloud.dataflow.completion.ProposalsCollectorSupportUtils;
import org.springframework.cloud.dataflow.completion.TaskExpansionStrategy;
import org.springframework.cloud.dataflow.configuration.metadata.ApplicationConfigurationMetadataResolver;
import org.springframework.cloud.dataflow.core.ApplicationType;
import org.springframework.cloud.dataflow.core.TaskDefinition;
import org.springframework.cloud.dataflow.registry.AppRegistryCommon;
import org.springframework.cloud.dataflow.registry.domain.AppRegistration;

class AddAppOptionsTaskExpansionStrategy
implements TaskExpansionStrategy {
    private final ProposalsCollectorSupportUtils collectorSupport;

    public AddAppOptionsTaskExpansionStrategy(AppRegistryCommon appRegistry, ApplicationConfigurationMetadataResolver metadataResolver) {
        this.collectorSupport = new ProposalsCollectorSupportUtils(appRegistry, metadataResolver);
    }

    @Override
    public boolean addProposals(String text, TaskDefinition taskDefinition, int detailLevel, List<CompletionProposal> collector) {
        String appName = taskDefinition.getRegisteredAppName();
        AppRegistration appRegistration = this.collectorSupport.findAppRegistration(appName, ApplicationType.task);
        if (appRegistration != null) {
            HashSet<String> alreadyPresentOptions = new HashSet<String>(taskDefinition.getProperties().keySet());
            this.collectorSupport.addPropertiesProposals(text, "", appRegistration, alreadyPresentOptions, collector, detailLevel);
        }
        return false;
    }
}

