/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.audit.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.dataflow.audit.repository.AuditRecordRepository;
import org.springframework.cloud.dataflow.audit.service.AuditRecordService;
import org.springframework.cloud.dataflow.core.ArgumentSanitizer;
import org.springframework.cloud.dataflow.core.AuditActionType;
import org.springframework.cloud.dataflow.core.AuditOperationType;
import org.springframework.cloud.dataflow.core.AuditRecord;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.util.Assert;

public class DefaultAuditRecordService
implements AuditRecordService {
    private static final Logger logger = LoggerFactory.getLogger(DefaultAuditRecordService.class);
    private final AuditRecordRepository auditRecordRepository;
    private final ObjectMapper objectMapper;
    private final ArgumentSanitizer sanitizer;

    public DefaultAuditRecordService(AuditRecordRepository auditRecordRepository) {
        this(auditRecordRepository, null);
    }

    public DefaultAuditRecordService(AuditRecordRepository auditRecordRepository, ObjectMapper objectMapper) {
        Assert.notNull((Object)auditRecordRepository, (String)"auditRecordRepository must not be null.");
        this.auditRecordRepository = auditRecordRepository;
        if (objectMapper == null) {
            objectMapper = new ObjectMapper();
            objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        }
        this.objectMapper = objectMapper;
        this.sanitizer = new ArgumentSanitizer();
    }

    @Override
    public AuditRecord populateAndSaveAuditRecord(AuditOperationType auditOperationType, AuditActionType auditActionType, String correlationId, String data, String platformName) {
        Assert.notNull((Object)auditActionType, (String)"auditActionType must not be null.");
        Assert.notNull((Object)auditOperationType, (String)"auditOperationType must not be null.");
        AuditRecord auditRecord = new AuditRecord();
        auditRecord.setAuditAction(auditActionType);
        auditRecord.setAuditOperation(auditOperationType);
        auditRecord.setCorrelationId(correlationId);
        auditRecord.setAuditData(data);
        auditRecord.setPlatformName(platformName);
        return this.auditRecordRepository.save(auditRecord);
    }

    @Override
    public AuditRecord populateAndSaveAuditRecordUsingMapData(AuditOperationType auditOperationType, AuditActionType auditActionType, String correlationId, Map<String, Object> data, String platformName) {
        String dataAsString;
        try {
            Map<String, Object> sanitizedData = this.sanitizeMap(data);
            dataAsString = this.objectMapper.writeValueAsString(sanitizedData);
        }
        catch (JsonProcessingException e) {
            logger.error("Error serializing audit record data.  Data = " + data);
            dataAsString = "Error serializing audit record data.  Data = " + data;
        }
        return this.populateAndSaveAuditRecord(auditOperationType, auditActionType, correlationId, dataAsString, platformName);
    }

    private Map<String, Object> sanitizeMap(Map<String, Object> data) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        data.forEach((k, v) -> result.put((String)k, this.sanitize((String)k, v)));
        return result;
    }

    private Object sanitize(String key, Object value) {
        if (value instanceof String) {
            return this.sanitizer.sanitize(key, (String)value);
        }
        if (value instanceof Map) {
            Map input = (Map)value;
            return this.sanitizeMap(input);
        }
        return value;
    }

    @Override
    public Page<AuditRecord> findAuditRecordByAuditOperationTypeAndAuditActionTypeAndDate(Pageable pageable, AuditActionType[] actions, AuditOperationType[] operations, Instant fromDate, Instant toDate) {
        return this.auditRecordRepository.findByActionTypeAndOperationTypeAndDate(operations, actions, fromDate, toDate, pageable);
    }

    @Override
    public Optional<AuditRecord> findById(Long id) {
        return this.auditRecordRepository.findById(id);
    }
}

