/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.wiremock.file;

import com.github.tomakehurst.wiremock.common.BinaryFile;
import com.github.tomakehurst.wiremock.common.ClasspathFileSource;
import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.common.SingleRootFileSource;
import com.github.tomakehurst.wiremock.common.TextFile;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

public class ResourcesFileSource
implements FileSource {
    private static final Log log = LogFactory.getLog(ResourcesFileSource.class);
    private final FileSource[] sources;

    public ResourcesFileSource(Resource ... resources) {
        this(ResourcesFileSource.toSources(resources));
    }

    protected ResourcesFileSource(FileSource ... sources) {
        this.sources = sources;
    }

    private static FileSource[] toSources(Resource[] resources) {
        FileSource[] sources = new FileSource[resources.length];
        for (int i = 0; i < resources.length; ++i) {
            Resource resource = resources[i];
            if (resource instanceof ClassPathResource) {
                ClassPathResource classes = (ClassPathResource)resource;
                sources[i] = new ClasspathFileSource(classes.getPath());
                continue;
            }
            if (resource instanceof FileSystemResource) {
                FileSystemResource files = (FileSystemResource)resource;
                sources[i] = new SingleRootFileSource(files.getFile());
                continue;
            }
            if (resource instanceof UrlResource) {
                sources[i] = ResourcesFileSource.fileOrFallbackToClasspath(resource);
                continue;
            }
            throw new IllegalArgumentException("Unsupported resource type for file source: " + String.valueOf(resource.getClass()));
        }
        return sources;
    }

    private static FileSource fileOrFallbackToClasspath(Resource resource) {
        UrlResource file = (UrlResource)resource;
        try {
            URI uri = file.getURI();
            if (ResourcesFileSource.compressedResource(uri)) {
                return new ClasspathFileSource(ResourcesFileSource.pathFromCompressed(uri));
            }
            return new SingleRootFileSource(ResourcesFileSource.getFile(file));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private static String pathFromCompressed(URI pathUri) {
        String path = pathUri.getSchemeSpecificPart().split("!")[1];
        return path.startsWith("/") ? path.substring(1) : path;
    }

    private static boolean compressedResource(URI pathUri) {
        return Arrays.asList("jar", "war", "ear", "zip").contains(pathUri.getScheme());
    }

    private static File getFile(UrlResource file) {
        try {
            return file.getFile();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public BinaryFile getBinaryFileNamed(String name) {
        for (FileSource resource : this.sources) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Trying FileSource with path " + resource.getPath()));
            }
            try {
                UrlResource relativeResource;
                ClasspathFileSource classpathFileSource;
                if (resource instanceof ClasspathFileSource && (classpathFileSource = (ClasspathFileSource)resource).exists() && ResourcesFileSource.compressedResource(classpathFileSource.getUri())) {
                    return classpathFileSource.getBinaryFileNamed(name);
                }
                UrlResource uri = new UrlResource(resource.getUri());
                if (!uri.exists() || !(relativeResource = new UrlResource(String.valueOf(uri.getURI()) + "/" + name)).exists()) continue;
                return resource.getBinaryFileNamed(name);
            }
            catch (RuntimeException e) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Caught exception while trying to create file handle for file " + name + ", trying next FileSource"), (Throwable)e);
            }
            catch (IOException e) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Caught exception while trying to create file handle for file " + name + ", trying next FileSource"), (Throwable)e);
            }
        }
        throw new IllegalStateException("Cannot create file handler for " + name);
    }

    public TextFile getTextFileNamed(String name) {
        for (FileSource resource : this.sources) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Trying FileSource with path " + resource.getPath()));
            }
            TextFile file = resource.getTextFileNamed(name);
            try {
                file.readContentsAsString();
                return file;
            }
            catch (RuntimeException e) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Caught exception while trying to create file handler for " + name), (Throwable)e);
            }
        }
        return null;
    }

    public void createIfNecessary() {
        throw new UnsupportedOperationException("Resource file sources are read-only");
    }

    public FileSource child(String subDirectoryName) {
        ArrayList<FileSource> childSources = new ArrayList<FileSource>();
        for (FileSource resource : this.sources) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Trying FileSource with path " + resource.getPath()));
            }
            try {
                UrlResource uri = new UrlResource(resource.child(subDirectoryName).getUri());
                if (!uri.exists()) continue;
                FileSource child = resource.child(subDirectoryName);
                childSources.add(child);
            }
            catch (IOException e) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Caught exception while trying to create file source for " + subDirectoryName + ", continuing with next source"), (Throwable)e);
            }
        }
        if (!childSources.isEmpty()) {
            return new ResourcesFileSource(childSources.toArray(new FileSource[0]));
        }
        return this.sources[0].child(subDirectoryName);
    }

    public String getPath() {
        for (FileSource resource : this.sources) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Trying FileSource with path " + resource.getPath()));
            }
            try {
                UrlResource uri = new UrlResource(resource.getUri());
                if (!uri.exists()) continue;
                return resource.getPath();
            }
            catch (IOException e) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Caught exception while trying to create URL file handler for " + resource.getPath() + ", continuing with next source"), (Throwable)e);
            }
        }
        return this.sources[0].getPath();
    }

    public URI getUri() {
        for (FileSource resource : this.sources) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Trying FileSource with path " + resource.getPath()));
            }
            try {
                UrlResource uri = new UrlResource(resource.getUri());
                if (!uri.exists()) continue;
                return resource.getUri();
            }
            catch (IOException e) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Caught exception while trying to create URL file handler for " + resource.getPath() + ", continuing with next source"), (Throwable)e);
            }
        }
        return this.sources[0].getUri();
    }

    public List<TextFile> listFilesRecursively() {
        ArrayList<TextFile> files = new ArrayList<TextFile>();
        for (FileSource resource : this.sources) {
            files.addAll(resource.listFilesRecursively());
        }
        return files;
    }

    public void writeTextFile(String name, String contents) {
        throw new UnsupportedOperationException("Resource file sources are read-only");
    }

    public void writeBinaryFile(String name, byte[] contents) {
        throw new UnsupportedOperationException("Resource file sources are read-only");
    }

    public boolean exists() {
        for (FileSource resource : this.sources) {
            if (!resource.exists()) continue;
            return true;
        }
        return false;
    }

    public void deleteFile(String name) {
    }
}

