/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.wiremock;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.contract.wiremock.WireMockConfiguration;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.support.AbstractTestExecutionListener;

public final class WireMockTestExecutionListener
extends AbstractTestExecutionListener {
    private static final Log log = LogFactory.getLog(WireMockTestExecutionListener.class);

    public void beforeTestClass(TestContext testContext) {
        block5: {
            try {
                if (this.wireMockConfigMissing(testContext)) {
                    return;
                }
                WireMockConfiguration wireMockConfiguration = this.wireMockConfiguration(testContext);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("WireMock configuration is running [" + wireMockConfiguration.isRunning() + "]"));
                }
                if (!wireMockConfiguration.isRunning()) {
                    wireMockConfiguration.reset();
                    wireMockConfiguration.init();
                    wireMockConfiguration.start();
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block5;
                log.debug((Object)"Exception occurred while trying to init WireMock configuration", (Throwable)e);
            }
        }
    }

    private boolean wireMockConfigMissing(TestContext testContext) {
        boolean missing;
        boolean bl = missing = !testContext.getApplicationContext().containsBean(WireMockConfiguration.class.getName());
        if (log.isDebugEnabled()) {
            log.debug((Object)("WireMockConfig is missing [" + missing + "]"));
        }
        return missing;
    }

    public void afterTestClass(TestContext testContext) {
        block3: {
            try {
                if (this.wireMockConfigMissing(testContext)) {
                    return;
                }
                this.stopWireMockConfiguration(testContext);
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block3;
                log.debug((Object)"Exception occurred while trying to init WireMock configuration", (Throwable)e);
            }
        }
    }

    private void stopWireMockConfiguration(TestContext testContext) {
        WireMockConfiguration wireMockConfiguration = this.wireMockConfiguration(testContext);
        if (wireMockConfiguration.isRunning()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"WireMock is running, will stop it");
            }
            wireMockConfiguration.stop();
        }
    }

    private WireMockConfiguration wireMockConfiguration(TestContext testContext) {
        return (WireMockConfiguration)testContext.getApplicationContext().getBean(WireMockConfiguration.class);
    }
}

