/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.util;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.PropertyWriter;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.cloud.contract.verifier.util.CantInstantiateThisClass;
import org.springframework.util.ReflectionUtils;

class MyFilter
extends SimpleBeanPropertyFilter
implements Serializable {
    private static final Map<Class, Object> CACHE = new ConcurrentHashMap<Class, Object>();

    MyFilter() {
    }

    public void serializeAsField(Object pojo, JsonGenerator jgen, SerializerProvider provider, PropertyWriter writer) throws Exception {
        if (pojo instanceof Map || pojo instanceof Collection) {
            writer.serializeAsField(pojo, jgen, provider);
            return;
        }
        Object defaultInstance = this.defaultInstance(pojo);
        if (defaultInstance instanceof CantInstantiateThisClass || !this.valueSameAsDefault(pojo, defaultInstance, writer.getName())) {
            writer.serializeAsField(pojo, jgen, provider);
        }
    }

    Object defaultInstance(Object pojo) {
        return CACHE.computeIfAbsent(pojo.getClass(), this::defaultInstance);
    }

    private Object defaultInstance(Class aClass) {
        try {
            return aClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            return new CantInstantiateThisClass();
        }
    }

    boolean valueSameAsDefault(Object pojo, Object defaultInstance, String fieldName) {
        Field field = ReflectionUtils.findField(pojo.getClass(), (String)fieldName);
        if (field == null) {
            return false;
        }
        ReflectionUtils.makeAccessible((Field)field);
        try {
            return Objects.equals(field.get(pojo), field.get(defaultInstance));
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }
}

