/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.util;

import groovy.json.JsonException;
import groovy.json.JsonOutput;
import groovy.json.JsonSlurper;
import groovy.lang.Closure;
import groovy.lang.GString;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import groovy.xml.XmlSlurper;
import java.beans.Transient;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.text.StringEscapeUtils;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.springframework.cloud.contract.spec.internal.DslProperty;
import org.springframework.cloud.contract.spec.internal.ExecutionProperty;
import org.springframework.cloud.contract.spec.internal.FromFileProperty;
import org.springframework.cloud.contract.spec.internal.Header;
import org.springframework.cloud.contract.spec.internal.Headers;
import org.springframework.cloud.contract.spec.internal.MatchingStrategy;
import org.springframework.cloud.contract.spec.internal.NamedProperty;
import org.springframework.cloud.contract.spec.internal.OptionalProperty;
import org.springframework.cloud.contract.verifier.template.HandlebarsTemplateProcessor;
import org.springframework.cloud.contract.verifier.util.CloneUtils;
import org.springframework.cloud.contract.verifier.util.ContentType;
import org.springframework.cloud.contract.verifier.util.MapConverter;
import org.springframework.util.StringUtils;
import org.xml.sax.ErrorHandler;
import org.xml.sax.helpers.DefaultHandler;

public class ContentUtils
implements GroovyObject {
    private static final Log log;
    public static final Closure GET_STUB_SIDE;
    public static final Closure GET_TEST_SIDE;
    public static final Function GET_STUB_SIDE_FUNCTION;
    public static final Function GET_TEST_SIDE_FUNCTION;
    private static final Pattern TEMPORARY_PATTERN_HOLDER;
    private static final Pattern TEMPORARY_EXECUTION_PATTERN_HOLDER;
    private static final Pattern TEMPORARY_OPTIONAL_PATTERN_HOLDER;
    private static final String JSON_VALUE_PATTERN_FOR_REGEX = "REGEXP>>%s<<";
    private static final String JSON_VALUE_PATTERN_FOR_OPTIONAL = "OPTIONAL>>%s<<";
    private static final String JSON_VALUE_PATTERN_FOR_EXECUTION = "\"EXECUTION>>%s<<\"";
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    @Generated
    public ContentUtils() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static Object extractValue(GString bodyAsValue, ContentType contentType, Closure valueProvider) {
        if (!StringUtils.hasText((String)bodyAsValue.toString())) {
            return bodyAsValue;
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)((Object)contentType), (Object)((Object)ContentType.TEXT)) || ScriptBytecodeAdapter.compareEqual((Object)((Object)contentType), (Object)((Object)ContentType.FORM))) {
            return ContentUtils.extractValueForText(bodyAsValue, valueProvider);
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)((Object)ContentType.JSON), (Object)((Object)contentType))) {
            return ContentUtils.extractValueForJSON(bodyAsValue, valueProvider);
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)((Object)contentType), (Object)((Object)ContentType.XML))) {
            return ContentUtils.extractValueForXML(bodyAsValue, valueProvider);
        }
        log.trace((Object)"No content type provided so trying to parse as JSON");
        Object object = ContentUtils.extractValueForJSON(bodyAsValue, valueProvider);
        try {
            return object;
        }
        catch (JsonException e) {
            log.trace((Object)"Failed to parse as JSON - trying to parse as XML", (Throwable)e);
            GStringImpl gStringImpl = ContentUtils.extractValueForXML(bodyAsValue, valueProvider);
            try {
                return gStringImpl;
            }
            catch (Exception exception) {
                log.trace((Object)"No content type provided and failed to parse as XML - returning the value back to the user", (Throwable)exception);
                GStringImpl gStringImpl2 = ContentUtils.extractValueForGString(bodyAsValue, valueProvider);
                return gStringImpl2;
            }
        }
    }

    public static Object extractValue(GString bodyAsValue, ContentType contentType, Function valueProvider) {
        Reference valueProvider2 = new Reference((Object)valueProvider);
        public final class _extractValue_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference valueProvider;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _extractValue_closure1(Object _outerInstance, Object _thisObject, Reference valueProvider) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.valueProvider = reference = valueProvider;
            }

            public Object doCall(Object it) {
                return ((Function)this.valueProvider.get()).apply(it);
            }

            @Generated
            public Function getValueProvider() {
                return IndyInterface.bootstrap("cast", "()", 0, this.valueProvider.get());
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _extractValue_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return ContentUtils.extractValue(bodyAsValue, contentType, new _extractValue_closure1(ContentUtils.class, ContentUtils.class, valueProvider2));
    }

    public static ContentType getClientContentType(GString bodyAsValue) {
        ContentUtils.extractValueForJSON(bodyAsValue, GET_STUB_SIDE);
        ContentType contentType = ContentType.JSON;
        try {
            return contentType;
        }
        catch (JsonException e) {
            ContentUtils.getXmlSlurperWithDefaultErrorHandler().parseText(ContentUtils.extractValueForXML(bodyAsValue, GET_STUB_SIDE).toString());
            ContentType contentType2 = ContentType.XML;
            try {
                return contentType2;
            }
            catch (Exception ignored) {
                ContentUtils.extractValueForGString(bodyAsValue, GET_STUB_SIDE);
                ContentType contentType3 = ContentType.UNKNOWN;
                return contentType3;
            }
        }
    }

    public static ContentType getClientContentType(String bodyAsValue) {
        new JsonSlurper().parseText(bodyAsValue);
        ContentType contentType = ContentType.JSON;
        try {
            return contentType;
        }
        catch (JsonException e) {
            ContentUtils.getXmlSlurperWithDefaultErrorHandler().parseText(bodyAsValue);
            ContentType contentType2 = ContentType.XML;
            try {
                return contentType2;
            }
            catch (Exception ignored) {
                ContentType contentType3 = ContentType.UNKNOWN;
                return contentType3;
            }
        }
    }

    public static ContentType getClientContentType(Object bodyAsValue) {
        if (bodyAsValue instanceof GString) {
            return ContentUtils.getClientContentType((GString)IndyInterface.bootstrap("cast", "()", 0, bodyAsValue));
        }
        if (bodyAsValue instanceof String) {
            return ContentUtils.getClientContentType((String)((Object)IndyInterface.bootstrap("cast", "()", 0, bodyAsValue)));
        }
        if (bodyAsValue instanceof Map) {
            return ContentUtils.getClientContentType((Map)((Object)IndyInterface.bootstrap("cast", "()", 0, bodyAsValue)));
        }
        if (bodyAsValue instanceof List) {
            return ContentUtils.getClientContentType((List)((Object)IndyInterface.bootstrap("cast", "()", 0, bodyAsValue)));
        }
        if (bodyAsValue instanceof MatchingStrategy) {
            return ContentType.UNKNOWN;
        }
        if (bodyAsValue instanceof FromFileProperty) {
            return ContentType.UNKNOWN;
        }
        return ContentUtils.tryToGuessContentType(bodyAsValue);
    }

    private static ContentType tryToGuessContentType(Object bodyAsValue) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"No content type passed, will try to guess the type of payload");
        }
        ContentType contentType = ContentUtils.getClientContentType(JsonOutput.toJson((Object)bodyAsValue));
        try {
            return contentType;
        }
        catch (Exception ignored) {
            if (log.isTraceEnabled()) {
                log.trace((Object)StringGroovyMethods.plus((String)StringGroovyMethods.plus((CharSequence)"Failed to assume that body [", (Object)bodyAsValue), (CharSequence)"] is json"));
            }
        }
        return ContentType.UNKNOWN;
    }

    public static ContentType getClientContentType(Object bodyAsValue, Headers headers) {
        ContentType contentType = ContentUtils.recognizeContentTypeFromHeader(headers);
        if (ScriptBytecodeAdapter.compareEqual((Object)((Object)contentType), (Object)((Object)ContentType.UNKNOWN))) {
            return ContentUtils.getClientContentType(bodyAsValue);
        }
        return contentType;
    }

    public static ContentType getClientContentType(Map bodyAsValue) {
        JsonOutput.toJson((Map)bodyAsValue);
        ContentType contentType = ContentType.JSON;
        try {
            return contentType;
        }
        catch (Exception ignore) {
            ContentType contentType2 = ContentType.UNKNOWN;
            return contentType2;
        }
    }

    public static ContentType getClientContentType(List bodyAsValue) {
        JsonOutput.toJson((Object)bodyAsValue);
        ContentType contentType = ContentType.JSON;
        try {
            return contentType;
        }
        catch (Exception ignore) {
            ContentType contentType2 = ContentType.UNKNOWN;
            return contentType2;
        }
    }

    public static GStringImpl extractValueForGString(GString bodyAsValue, Closure valueProvider) {
        Reference valueProvider2 = new Reference((Object)valueProvider);
        public final class _extractValueForGString_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference valueProvider;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _extractValueForGString_closure2(Object _outerInstance, Object _thisObject, Reference valueProvider) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.valueProvider = reference = valueProvider;
            }

            public Object doCall(Object it) {
                return it instanceof DslProperty ? ((Closure)this.valueProvider.get()).call(it) : it;
            }

            @Generated
            public Closure getValueProvider() {
                return IndyInterface.bootstrap("cast", "()", 0, this.valueProvider.get());
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _extractValueForGString_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return new GStringImpl((Object[])((String[])IndyInterface.bootstrap("invoke", "asType", 0, DefaultGroovyMethods.collect((Object[])bodyAsValue.getValues(), (Closure)new _extractValueForGString_closure2(ContentUtils.class, ContentUtils.class, valueProvider2)), String[].class)), (String[])IndyInterface.bootstrap("invoke", "asType", 0, CloneUtils.clone(bodyAsValue.getStrings()), String[].class));
    }

    public static Object extractValue(GString bodyAsValue, Function valueProvider) {
        Reference valueProvider2 = new Reference((Object)valueProvider);
        public final class _extractValue_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference valueProvider;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _extractValue_closure3(Object _outerInstance, Object _thisObject, Reference valueProvider) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.valueProvider = reference = valueProvider;
            }

            public Object doCall(Object it) {
                return ((Function)this.valueProvider.get()).apply(it);
            }

            @Generated
            public Function getValueProvider() {
                return IndyInterface.bootstrap("cast", "()", 0, this.valueProvider.get());
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _extractValue_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return ContentUtils.extractValue(bodyAsValue, ContentType.UNKNOWN, new _extractValue_closure3(ContentUtils.class, ContentUtils.class, valueProvider2));
    }

    public static Object extractValue(GString bodyAsValue, Closure valueProvider) {
        return ContentUtils.extractValue(bodyAsValue, ContentType.UNKNOWN, valueProvider);
    }

    private static String extractValueForText(GString bodyAsValue, Closure valueProvider) {
        Reference valueProvider2 = new Reference((Object)valueProvider);
        public final class _extractValueForText_closure4
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference valueProvider;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _extractValueForText_closure4(Object _outerInstance, Object _thisObject, Reference valueProvider) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.valueProvider = reference = valueProvider;
            }

            public Object doCall(Object it) {
                return ((Closure)this.valueProvider.get()).call(it);
            }

            @Generated
            public Closure getValueProvider() {
                return IndyInterface.bootstrap("cast", "()", 0, this.valueProvider.get());
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _extractValueForText_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        GStringImpl transformedString = new GStringImpl((Object[])((String[])IndyInterface.bootstrap("invoke", "asType", 0, DefaultGroovyMethods.collect((Object[])bodyAsValue.getValues(), (Closure)new _extractValueForText_closure4(ContentUtils.class, ContentUtils.class, valueProvider2)), String[].class)), (String[])IndyInterface.bootstrap("invoke", "asType", 0, CloneUtils.clone(bodyAsValue.getStrings()), String[].class));
        return transformedString.toString();
    }

    private static Object extractValueForJSON(GString bodyAsValue, Closure valueProvider) {
        Reference valueProvider2 = new Reference((Object)valueProvider);
        public final class _extractValueForJSON_closure5
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference valueProvider;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _extractValueForJSON_closure5(Object _outerInstance, Object _thisObject, Reference valueProvider) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.valueProvider = reference = valueProvider;
            }

            public Object doCall(Object it) {
                return InvokerHelper.invokeStaticMethod(ContentUtils.class, (String)"transformJSONStringValue", (Object)new Object[]{it, this.valueProvider.get()});
            }

            @Generated
            public Closure getValueProvider() {
                return IndyInterface.bootstrap("cast", "()", 0, this.valueProvider.get());
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _extractValueForJSON_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        GStringImpl transformedString = new GStringImpl((Object[])((String[])IndyInterface.bootstrap("invoke", "asType", 0, DefaultGroovyMethods.collect((Object[])bodyAsValue.getValues(), (Closure)new _extractValueForJSON_closure5(ContentUtils.class, ContentUtils.class, valueProvider2)), String[].class)), (String[])IndyInterface.bootstrap("invoke", "asType", 0, CloneUtils.clone(bodyAsValue.getStrings()), String[].class));
        Object parsedJson = new JsonSlurper().parseText(transformedString.toString().replace("\\", "\\\\"));
        return ContentUtils.convertAllTemporaryRegexPlaceholdersBackToPatterns(parsedJson);
    }

    private static GStringImpl extractValueForXML(GString bodyAsValue, Closure valueProvider) {
        Reference valueProvider2 = new Reference((Object)valueProvider);
        public final class _extractValueForXML_closure6
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference valueProvider;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _extractValueForXML_closure6(Object _outerInstance, Object _thisObject, Reference valueProvider) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.valueProvider = reference = valueProvider;
            }

            public String doCall(Object it) {
                return ContentUtils.transformXMLStringValue(it, (Closure)IndyInterface.bootstrap("cast", "()", 0, this.valueProvider.get()));
            }

            @Generated
            public Closure getValueProvider() {
                return IndyInterface.bootstrap("cast", "()", 0, this.valueProvider.get());
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public String doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _extractValueForXML_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        GStringImpl impl = new GStringImpl((Object[])((String[])IndyInterface.bootstrap("invoke", "asType", 0, DefaultGroovyMethods.collect((Object[])bodyAsValue.getValues(), (Closure)new _extractValueForXML_closure6(ContentUtils.class, ContentUtils.class, valueProvider2)), String[].class)), (String[])IndyInterface.bootstrap("invoke", "asType", 0, CloneUtils.clone(bodyAsValue.getStrings()), String[].class));
        ContentUtils.getXmlSlurperWithDefaultErrorHandler().parseText(impl.toString());
        return impl;
    }

    protected static Object transformJSONStringValue(Object obj, Closure valueProvider) {
        if (obj instanceof DslProperty) {
            return ContentUtils.transformJSONStringValue((DslProperty)IndyInterface.bootstrap("cast", "()", 0, obj), valueProvider);
        }
        if (obj instanceof Pattern) {
            return ContentUtils.transformJSONStringValue((Pattern)((Object)IndyInterface.bootstrap("cast", "()", 0, obj)), valueProvider);
        }
        if (obj instanceof OptionalProperty) {
            return ContentUtils.transformJSONStringValue((OptionalProperty)IndyInterface.bootstrap("cast", "()", 0, obj), valueProvider);
        }
        if (obj instanceof ExecutionProperty) {
            return ContentUtils.transformJSONStringValue((ExecutionProperty)IndyInterface.bootstrap("cast", "()", 0, obj), valueProvider);
        }
        return obj;
    }

    protected static Object transformJSONStringValue(DslProperty dslProperty, Closure valueProvider) {
        return ContentUtils.transformJSONStringValue(valueProvider.call((Object)dslProperty), valueProvider);
    }

    protected static Object transformJSONStringValue(Pattern pattern, Closure valueProvider) {
        return String.format(JSON_VALUE_PATTERN_FOR_REGEX, pattern.pattern());
    }

    protected static Object transformJSONStringValue(OptionalProperty optional, Closure valueProvider) {
        return String.format(JSON_VALUE_PATTERN_FOR_OPTIONAL, optional.value());
    }

    protected static Object transformJSONStringValue(ExecutionProperty property, Closure valueProvider) {
        return String.format(JSON_VALUE_PATTERN_FOR_EXECUTION, property.getExecutionCommand());
    }

    private static String transformXMLStringValue(Object obj, Closure valueProvider) {
        if (obj instanceof DslProperty) {
            return IndyInterface.bootstrap("cast", "()", 0, ContentUtils.transformJSONStringValue((DslProperty)IndyInterface.bootstrap("cast", "()", 0, obj), valueProvider));
        }
        return StringEscapeUtils.escapeXml11((String)StringEscapeUtils.unescapeXml((String)DefaultGroovyMethods.toString((Object)obj)));
    }

    private static String transformXMLStringValue(DslProperty dslProperty, Closure valueProvider) {
        return ContentUtils.transformXMLStringValue(valueProvider.call((Object)dslProperty), valueProvider);
    }

    protected static Object convertDslPropsToTemporaryRegexPatterns(Object parsedJson, Closure parsingClosure) {
        public final class _convertDslPropsToTemporaryRegexPatterns_closure7
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _convertDslPropsToTemporaryRegexPatterns_closure7(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object value) {
                return InvokerHelper.invokeStaticMethod(ContentUtils.class, (String)"transformJSONStringValue", (Object)new Object[]{value, this.getProperty("GET_TEST_SIDE")});
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _convertDslPropsToTemporaryRegexPatterns_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return MapConverter.transformValues(parsedJson, IndyInterface.bootstrap("cast", "()", 0, new _convertDslPropsToTemporaryRegexPatterns_closure7(ContentUtils.class, ContentUtils.class)), (Function<String, Object>)((Object)IndyInterface.bootstrap("cast", "()", 0, parsingClosure)));
    }

    private static Object convertAllTemporaryRegexPlaceholdersBackToPatterns(Object parsedJson) {
        public final class _convertAllTemporaryRegexPlaceholdersBackToPatterns_closure8
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _convertAllTemporaryRegexPlaceholdersBackToPatterns_closure8(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object value) {
                if (value instanceof String) {
                    CallSite string = IndyInterface.bootstrap("cast", "()", 0, value);
                    return ContentUtils.returnParsedObject(string);
                }
                return value;
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _convertAllTemporaryRegexPlaceholdersBackToPatterns_closure8.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return MapConverter.transformValues(parsedJson, IndyInterface.bootstrap("cast", "()", 0, new _convertAllTemporaryRegexPlaceholdersBackToPatterns_closure8(ContentUtils.class, ContentUtils.class)));
    }

    public static Object returnParsedObject(Object object) {
        if (!(object instanceof String)) {
            return object;
        }
        CallSite string = IndyInterface.bootstrap("cast", "()", 0, object);
        Matcher matcher = TEMPORARY_PATTERN_HOLDER.matcher(((String)((Object)string)).trim());
        if (matcher.matches()) {
            return Pattern.compile(ContentUtils.patternFromMatchingGroup(matcher));
        }
        Matcher executionMatcher = TEMPORARY_EXECUTION_PATTERN_HOLDER.matcher(((String)((Object)string)).trim());
        if (executionMatcher.matches()) {
            return new ExecutionProperty(ContentUtils.patternFromMatchingGroup(executionMatcher));
        }
        Matcher optionalMatcher = TEMPORARY_OPTIONAL_PATTERN_HOLDER.matcher(((String)((Object)string)).trim());
        if (optionalMatcher.matches()) {
            String patternToMatch = ContentUtils.patternFromMatchingGroup(optionalMatcher);
            return Pattern.compile(new OptionalProperty((Object)patternToMatch).optionalPattern());
        }
        return string;
    }

    private static String patternFromMatchingGroup(Matcher matcher) {
        List val = (List)((Object)IndyInterface.bootstrap("invoke", "asType", 0, StringGroovyMethods.getAt((Matcher)matcher, (int)0), List.class));
        return IndyInterface.bootstrap("cast", "()", 0, DefaultGroovyMethods.getAt((List)val, (int)1));
    }

    public static ContentType recognizeContentTypeFromHeader(Headers headers, Closure<Object> closure) {
        Headers headers2 = headers;
        Set set = headers2 != null ? headers2.getEntries() : null;
        public final class _recognizeContentTypeFromHeader_closure9
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _recognizeContentTypeFromHeader_closure9(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Boolean doCall(Object it) {
                return ScriptBytecodeAdapter.compareEqual((Object)((Header)it).getName(), (Object)"Content-Type") || ScriptBytecodeAdapter.compareEqual((Object)((Header)it).getName(), (Object)"contentType");
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Boolean doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _recognizeContentTypeFromHeader_closure9.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite header = IndyInterface.bootstrap("cast", "()", 0, set != null ? DefaultGroovyMethods.find((Collection)set, (Closure)new _recognizeContentTypeFromHeader_closure9(ContentUtils.class, ContentUtils.class)) : null);
        Object object = closure.call((Object)header);
        String content = object != null ? DefaultGroovyMethods.toString((Object)object) : null;
        String string = content;
        Boolean bl = string != null ? Boolean.valueOf(string.contains("json")) : null;
        if (bl == null ? false : bl) {
            return ContentType.JSON;
        }
        String string2 = content;
        Boolean bl2 = string2 != null ? Boolean.valueOf(string2.contains("xml")) : null;
        if (bl2 == null ? false : bl2) {
            return ContentType.XML;
        }
        String string3 = content;
        Boolean bl3 = string3 != null ? Boolean.valueOf(string3.contains("text")) : null;
        if (bl3 == null ? false : bl3) {
            return ContentType.TEXT;
        }
        String string4 = content;
        Boolean bl4 = string4 != null ? Boolean.valueOf(string4.contains("form-urlencoded")) : null;
        if (bl4 == null ? false : bl4) {
            return ContentType.FORM;
        }
        String string5 = content;
        Boolean bl5 = string5 != null ? Boolean.valueOf(string5.contains("octet-stream")) : null;
        if (bl5 == null ? false : bl5) {
            return ContentType.UNKNOWN;
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)content) && ContentUtils.isNotTemplate(content)) {
            return ContentType.DEFINED;
        }
        return ContentType.UNKNOWN;
    }

    public static ContentType recognizeContentTypeFromHeader(Headers headers) {
        public final class _recognizeContentTypeFromHeader_closure10
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _recognizeContentTypeFromHeader_closure10(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Header header) {
                Header header2 = header;
                return header2 != null ? header2.getClientValue() : null;
            }

            @Generated
            public Object call(Header header) {
                return this.doCall(header);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _recognizeContentTypeFromHeader_closure10.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return ContentUtils.recognizeContentTypeFromHeader(headers, new _recognizeContentTypeFromHeader_closure10(ContentUtils.class, ContentUtils.class));
    }

    public static ContentType recognizeContentTypeFromTestHeader(Headers headers) {
        public final class _recognizeContentTypeFromTestHeader_closure11
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _recognizeContentTypeFromTestHeader_closure11(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Header header) {
                Header header2 = header;
                return header2 != null ? header2.getServerValue() : null;
            }

            @Generated
            public Object call(Header header) {
                return this.doCall(header);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _recognizeContentTypeFromTestHeader_closure11.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return ContentUtils.recognizeContentTypeFromHeader(headers, new _recognizeContentTypeFromTestHeader_closure11(ContentUtils.class, ContentUtils.class));
    }

    public static MatchingStrategy.Type getEqualsTypeFromContentType(ContentType contentType) {
        ContentType contentType2 = contentType;
        if (ScriptBytecodeAdapter.isCase((Object)((Object)contentType2), (Object)((Object)ContentType.JSON))) {
            return MatchingStrategy.Type.EQUAL_TO_JSON;
        }
        if (ScriptBytecodeAdapter.isCase((Object)((Object)contentType2), (Object)((Object)ContentType.XML))) {
            return MatchingStrategy.Type.EQUAL_TO_XML;
        }
        return MatchingStrategy.Type.EQUAL_TO;
    }

    public static ContentType recognizeContentTypeFromContent(GString gstring) {
        if (ContentUtils.isJsonType(gstring)) {
            return ContentType.JSON;
        }
        if (ContentUtils.isXmlType(gstring)) {
            return ContentType.XML;
        }
        return ContentType.UNKNOWN;
    }

    public static ContentType recognizeContentTypeFromContent(Map jsonMap) {
        return ContentType.JSON;
    }

    public static ContentType recognizeContentTypeFromContent(byte ... bytes) {
        return ContentType.UNKNOWN;
    }

    public static ContentType recognizeContentTypeFromContent(List jsonList) {
        return ContentType.JSON;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ContentType recognizeContentTypeFromContent(String string) {
        try {
            new JsonSlurper().parseText(string);
            return ContentType.JSON;
        }
        catch (Exception ignored) {
            if (!ContentUtils.isXmlType((GString)new GStringImpl(new Object[]{string}, new String[]{"", ""}))) return ContentType.UNKNOWN;
            ContentType contentType = ContentType.XML;
            return contentType;
        }
    }

    public static ContentType recognizeContentTypeFromContent(Number number) {
        return ContentType.TEXT;
    }

    public static ContentType recognizeContentTypeFromContent(Object object) {
        if (object instanceof FromFileProperty) {
            CallSite property = IndyInterface.bootstrap("cast", "()", 0, object);
            if (property.isJson()) {
                return ContentType.JSON;
            }
            if (property.isXml()) {
                return ContentType.XML;
            }
            Object object2 = ((FromFileProperty)object).isByte() ? ((FromFileProperty)object).asBytes() : (Object)((FromFileProperty)object).asString();
            object = object2;
        }
        if (object instanceof GString) {
            return ContentUtils.recognizeContentTypeFromContent((GString)IndyInterface.bootstrap("cast", "()", 0, object));
        }
        if (object instanceof Map) {
            return ContentUtils.recognizeContentTypeFromContent((Map)((Object)IndyInterface.bootstrap("cast", "()", 0, object)));
        }
        if (object instanceof byte[]) {
            return ContentUtils.recognizeContentTypeFromContent((byte[])IndyInterface.bootstrap("cast", "()", 0, object));
        }
        if (object instanceof List) {
            return ContentUtils.recognizeContentTypeFromContent((List)((Object)IndyInterface.bootstrap("cast", "()", 0, object)));
        }
        if (object instanceof String) {
            return ContentUtils.recognizeContentTypeFromContent((String)((Object)IndyInterface.bootstrap("cast", "()", 0, object)));
        }
        if (object instanceof Number) {
            return ContentUtils.recognizeContentTypeFromContent((Number)((Object)IndyInterface.bootstrap("cast", "()", 0, object)));
        }
        return ContentType.UNKNOWN;
    }

    public static boolean isJsonType(GString gstring) {
        if (gstring.isEmpty()) {
            return false;
        }
        public final class _isJsonType_closure12
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _isJsonType_closure12(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public String doCall(Object it) {
                return it instanceof String || it instanceof GString ? ((String)it).toString() : StringEscapeUtils.escapeJson((String)DefaultGroovyMethods.toString((Object)it));
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public String doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _isJsonType_closure12.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        GStringImpl stringWithoutValues = new GStringImpl((Object[])IndyInterface.bootstrap("invoke", "asType", 0, DefaultGroovyMethods.collect((Object[])gstring.getValues(), (Closure)new _isJsonType_closure12(ContentUtils.class, ContentUtils.class)), Object[].class), (String[])IndyInterface.bootstrap("invoke", "asType", 0, CloneUtils.clone(gstring.getStrings()), String[].class));
        new JsonSlurper().parseText(stringWithoutValues.toString());
        boolean bl = true;
        try {
            return bl;
        }
        catch (JsonException e) {
        }
        return false;
    }

    public static boolean isXmlType(GString gString) {
        public final class _isXmlType_closure13
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _isXmlType_closure13(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public String doCall(Object it) {
                return it instanceof String || it instanceof GString ? ((String)it).toString() : StringEscapeUtils.escapeXml11((String)DefaultGroovyMethods.toString((Object)it));
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public String doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _isXmlType_closure13.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        GStringImpl stringWithoutValues = new GStringImpl((Object[])IndyInterface.bootstrap("invoke", "asType", 0, DefaultGroovyMethods.collect((Object[])gString.getValues(), (Closure)new _isXmlType_closure13(ContentUtils.class, ContentUtils.class)), Object[].class), (String[])IndyInterface.bootstrap("invoke", "asType", 0, CloneUtils.clone(gString.getStrings()), String[].class));
        ContentUtils.getXmlSlurperWithDefaultErrorHandler().parseText(stringWithoutValues.toString());
        boolean bl = true;
        try {
            return bl;
        }
        catch (Exception ignored) {
        }
        return false;
    }

    public static ContentType recognizeContentTypeFromMatchingStrategy(MatchingStrategy.Type type) {
        MatchingStrategy.Type type2 = type;
        if (ScriptBytecodeAdapter.isCase((Object)type2, (Object)MatchingStrategy.Type.EQUAL_TO_XML)) {
            return ContentType.XML;
        }
        if (ScriptBytecodeAdapter.isCase((Object)type2, (Object)MatchingStrategy.Type.EQUAL_TO_JSON)) {
            return ContentType.JSON;
        }
        return ContentType.UNKNOWN;
    }

    public static String getGroovyMultipartFileParameterContent(String propertyName, NamedProperty propertyValue, Closure<String> bytesFromFile) {
        return IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{propertyName, ContentUtils.namedPropertyName(propertyValue, "'")}, new String[]{"'", "', ", ", "}).plus((GString)new GStringImpl(new Object[]{ContentUtils.groovyNamedPropertyValue(propertyValue, "'", bytesFromFile)}, new String[]{"", ""})).plus(ContentUtils.namedContentTypeNameIfPresent(propertyValue, "'")));
    }

    public static String getGroovyMultipartFileParameterContent(String propertyName, NamedProperty propertyValue, Function<FromFileProperty, String> bytesFromFile) {
        Reference bytesFromFile2 = new Reference(bytesFromFile);
        public final class _getGroovyMultipartFileParameterContent_closure14
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference bytesFromFile;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getGroovyMultipartFileParameterContent_closure14(Object _outerInstance, Object _thisObject, Reference bytesFromFile) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.bytesFromFile = reference = bytesFromFile;
            }

            public String doCall(FromFileProperty property) {
                return IndyInterface.bootstrap("cast", "()", 0, ((Function)this.bytesFromFile.get()).apply(property));
            }

            @Generated
            public String call(FromFileProperty property) {
                return this.doCall(property);
            }

            @Generated
            public Function getBytesFromFile() {
                return IndyInterface.bootstrap("cast", "()", 0, this.bytesFromFile.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getGroovyMultipartFileParameterContent_closure14.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{propertyName, ContentUtils.namedPropertyName(propertyValue, "'")}, new String[]{"'", "', ", ", "}).plus((GString)new GStringImpl(new Object[]{ContentUtils.groovyNamedPropertyValue(propertyValue, "'", new _getGroovyMultipartFileParameterContent_closure14(ContentUtils.class, ContentUtils.class, bytesFromFile2))}, new String[]{"", ""})).plus(ContentUtils.namedContentTypeNameIfPresent(propertyValue, "'")));
    }

    public static String getJavaMultipartFileParameterContent(String propertyName, NamedProperty propertyValue, Function<FromFileProperty, String> bytesFromFile) {
        Reference bytesFromFile2 = new Reference(bytesFromFile);
        public final class _getJavaMultipartFileParameterContent_closure15
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference bytesFromFile;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getJavaMultipartFileParameterContent_closure15(Object _outerInstance, Object _thisObject, Reference bytesFromFile) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.bytesFromFile = reference = bytesFromFile;
            }

            public String doCall(FromFileProperty property) {
                return IndyInterface.bootstrap("cast", "()", 0, ((Function)this.bytesFromFile.get()).apply(property));
            }

            @Generated
            public String call(FromFileProperty property) {
                return this.doCall(property);
            }

            @Generated
            public Function getBytesFromFile() {
                return IndyInterface.bootstrap("cast", "()", 0, this.bytesFromFile.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getJavaMultipartFileParameterContent_closure15.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return ContentUtils.getJavaMultipartFileParameterContent(propertyName, propertyValue, new _getJavaMultipartFileParameterContent_closure15(ContentUtils.class, ContentUtils.class, bytesFromFile2));
    }

    public static String getJavaMultipartFileParameterContent(String propertyName, NamedProperty propertyValue, Closure<String> bytesFromFile) {
        return IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{StringEscapeUtils.escapeJava((String)propertyName), ContentUtils.namedPropertyName(propertyValue, "\"")}, new String[]{"\"", "\", ", ", "}).plus((GString)new GStringImpl(new Object[]{ContentUtils.javaNamedPropertyValue(propertyValue, "\"", bytesFromFile), ContentUtils.namedContentTypeNameIfPresent(propertyValue, "\"")}, new String[]{"", "", ""})));
    }

    public static String namedPropertyName(NamedProperty property, String quote) {
        return property.getName().getServerValue() instanceof ExecutionProperty ? ((ExecutionProperty)property.getName().getServerValue()).toString() : StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)quote, (CharSequence)StringEscapeUtils.escapeJava((String)DefaultGroovyMethods.toString((Object)property.getName().getServerValue()))), (CharSequence)quote);
    }

    public static String namedContentTypeNameIfPresent(NamedProperty property, String quote) {
        if (IndyInterface.bootstrap("cast", "()", 0, property.getContentType()) == false) {
            return "";
        }
        String contentType = property.getContentType().getServerValue() instanceof ExecutionProperty ? ((ExecutionProperty)property.getContentType().getServerValue()).toString() : StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)quote, (CharSequence)StringEscapeUtils.escapeJava((String)DefaultGroovyMethods.toString((Object)property.getContentType().getServerValue()))), (CharSequence)quote);
        return StringGroovyMethods.plus((String)", ", (CharSequence)contentType);
    }

    public static String groovyNamedPropertyValue(NamedProperty property, String quote, Closure<String> bytesFromFile) {
        if (property.getValue().getServerValue() instanceof ExecutionProperty) {
            return ((ExecutionProperty)property.getValue().getServerValue()).toString();
        }
        if (property.getValue().getServerValue() instanceof byte[]) {
            CallSite bytes = IndyInterface.bootstrap("cast", "()", 0, property.getValue().getServerValue());
            public final class _groovyNamedPropertyValue_closure16
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _groovyNamedPropertyValue_closure16(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    return it;
                }

                @Generated
                public Object call(Object args) {
                    return this.doCall(args);
                }

                @Generated
                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _groovyNamedPropertyValue_closure16.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            return StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"[", (CharSequence)DefaultGroovyMethods.join((Iterable)DefaultGroovyMethods.collect((Object)bytes, (Closure)new _groovyNamedPropertyValue_closure16(ContentUtils.class, ContentUtils.class)), (String)", ")), (CharSequence)"] as byte[]");
        }
        if (property.getValue().getServerValue() instanceof FromFileProperty) {
            CallSite fromFileProperty = IndyInterface.bootstrap("cast", "()", 0, property.getValue().getServerValue());
            if (fromFileProperty.isByte()) {
                return IndyInterface.bootstrap("cast", "()", 0, bytesFromFile.call((Object)fromFileProperty));
            }
            public final class _groovyNamedPropertyValue_closure17
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _groovyNamedPropertyValue_closure17(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    return it;
                }

                @Generated
                public Object call(Object args) {
                    return this.doCall(args);
                }

                @Generated
                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _groovyNamedPropertyValue_closure17.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            return StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"[", (CharSequence)DefaultGroovyMethods.join((Iterable)DefaultGroovyMethods.collect((Object)fromFileProperty.asBytes(), (Closure)new _groovyNamedPropertyValue_closure17(ContentUtils.class, ContentUtils.class)), (String)", ")), (CharSequence)"] as byte[]");
        }
        return StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)quote, (CharSequence)StringEscapeUtils.escapeJava((String)DefaultGroovyMethods.toString((Object)property.getValue().getServerValue()))), (CharSequence)quote), (CharSequence)".bytes");
    }

    public static String javaNamedPropertyValue(NamedProperty property, String quote, Closure<String> bytesFromFile) {
        if (property.getValue().getServerValue() instanceof ExecutionProperty) {
            return ((ExecutionProperty)property.getValue().getServerValue()).toString();
        }
        if (property.getValue().getServerValue() instanceof byte[]) {
            CallSite bytes = IndyInterface.bootstrap("cast", "()", 0, property.getValue().getServerValue());
            public final class _javaNamedPropertyValue_closure18
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _javaNamedPropertyValue_closure18(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    return it;
                }

                @Generated
                public Object call(Object args) {
                    return this.doCall(args);
                }

                @Generated
                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _javaNamedPropertyValue_closure18.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            return StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"new byte[] {", (CharSequence)DefaultGroovyMethods.join((Iterable)DefaultGroovyMethods.collect((Object)bytes, (Closure)new _javaNamedPropertyValue_closure18(ContentUtils.class, ContentUtils.class)), (String)", ")), (CharSequence)"}");
        }
        if (property.getValue().getServerValue() instanceof FromFileProperty) {
            CallSite fromFileProperty = IndyInterface.bootstrap("cast", "()", 0, property.getValue().getServerValue());
            if (fromFileProperty.isByte()) {
                return IndyInterface.bootstrap("cast", "()", 0, bytesFromFile.call((Object)fromFileProperty));
            }
            public final class _javaNamedPropertyValue_closure19
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _javaNamedPropertyValue_closure19(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    return it;
                }

                @Generated
                public Object call(Object args) {
                    return this.doCall(args);
                }

                @Generated
                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _javaNamedPropertyValue_closure19.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            return StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"new byte[] {", (CharSequence)DefaultGroovyMethods.join((Iterable)DefaultGroovyMethods.collect((Object)fromFileProperty.asBytes(), (Closure)new _javaNamedPropertyValue_closure19(ContentUtils.class, ContentUtils.class)), (String)", ")), (CharSequence)"}");
        }
        return StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)quote, (CharSequence)StringEscapeUtils.escapeJava((String)DefaultGroovyMethods.toString((Object)property.getValue().getServerValue()))), (CharSequence)quote), (CharSequence)".getBytes()");
    }

    public static ContentType evaluateClientSideContentType(Headers contractHeaders, Object body) {
        ContentType contentType = ContentUtils.recognizeContentTypeFromHeader(contractHeaders);
        if (ScriptBytecodeAdapter.compareEqual((Object)((Object)ContentType.UNKNOWN), (Object)((Object)contentType))) {
            ContentType contentType2;
            contentType = contentType2 = ContentUtils.recognizeContentTypeFromContent(body);
        }
        return contentType;
    }

    public static ContentType evaluateServerSideContentType(Headers contractHeaders, Object body) {
        ContentType contentType = ContentUtils.recognizeContentTypeFromTestHeader(contractHeaders);
        if (ScriptBytecodeAdapter.compareEqual((Object)((Object)ContentType.UNKNOWN), (Object)((Object)contentType))) {
            ContentType contentType2;
            contentType = contentType2 = ContentUtils.recognizeContentTypeFromContent(body);
        }
        return contentType;
    }

    public static XmlSlurper getXmlSlurperWithDefaultErrorHandler() {
        XmlSlurper xmlSlurper = new XmlSlurper();
        xmlSlurper.setErrorHandler((ErrorHandler)new DefaultHandler());
        return xmlSlurper;
    }

    private static boolean isNotTemplate(String content) {
        return !new HandlebarsTemplateProcessor().containsTemplateEntry(content);
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(ContentUtils.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, ContentUtils.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(ContentUtils.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
    }

    @Generated
    protected static Object convertDslPropsToTemporaryRegexPatterns(Object parsedJson) {
        return ContentUtils.convertDslPropsToTemporaryRegexPatterns(parsedJson, (Closure)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "JSON_PARSING_CLOSURE", 0, MapConverter.class)));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ContentUtils.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    static {
        Pattern pattern;
        Pattern pattern2;
        Pattern pattern3;
        Log log;
        ContentUtils.log = log = LogFactory.getLog(ContentUtils.class);
        public final class __clinit__closure20
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public __clinit__closure20(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return it instanceof DslProperty ? ((DslProperty)it).getClientValue() : it;
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != __clinit__closure20.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        __clinit__closure20 __clinit__closure202 = new __clinit__closure20(ContentUtils.class, ContentUtils.class);
        GET_STUB_SIDE = __clinit__closure202;
        public final class __clinit__closure21
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public __clinit__closure21(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return it instanceof DslProperty ? ((DslProperty)it).getServerValue() : it;
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != __clinit__closure21.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        __clinit__closure21 __clinit__closure212 = new __clinit__closure21(ContentUtils.class, ContentUtils.class);
        GET_TEST_SIDE = __clinit__closure212;
        1 var3_3 = new 1();
        GET_STUB_SIDE_FUNCTION = var3_3;
        2 var4_4 = new 2();
        GET_TEST_SIDE_FUNCTION = var4_4;
        TEMPORARY_PATTERN_HOLDER = pattern3 = Pattern.compile(".*REGEXP>>(.*)<<.*");
        TEMPORARY_EXECUTION_PATTERN_HOLDER = pattern2 = Pattern.compile("[\"]?EXECUTION>>(.*)<<[\"]?");
        TEMPORARY_OPTIONAL_PATTERN_HOLDER = pattern = Pattern.compile("OPTIONAL>>(.*)<<");
    }

    public class 1
    implements Function,
    GroovyObject {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;

        /* synthetic */ 1() {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        public Object apply(Object it) {
            return it instanceof DslProperty ? ((DslProperty)it).getClientValue() : it;
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(1.class, ContentUtils.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(1.class, ContentUtils.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setProperty((Object)object, null, ContentUtils.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setProperty((Object)object, null, ContentUtils.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(1.class, ContentUtils.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(1.class, ContentUtils.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != 1.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ MethodHandles.Lookup $getLookup() {
            return MethodHandles.lookup();
        }
    }

    public class 2
    implements Function,
    GroovyObject {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;

        /* synthetic */ 2() {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        public Object apply(Object it) {
            return it instanceof DslProperty ? ((DslProperty)it).getServerValue() : it;
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(2.class, ContentUtils.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(2.class, ContentUtils.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setProperty((Object)object, null, ContentUtils.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setProperty((Object)object, null, ContentUtils.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(2.class, ContentUtils.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(2.class, ContentUtils.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != 2.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ MethodHandles.Lookup $getLookup() {
            return MethodHandles.lookup();
        }
    }
}

