/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.builder;

import org.springframework.cloud.contract.verifier.builder.BlockBuilder;
import org.springframework.cloud.contract.verifier.builder.GeneratedClassMetaData;
import org.springframework.cloud.contract.verifier.builder.GeneratedTestClassBuilder;
import org.springframework.cloud.contract.verifier.builder.JUnit4OrderClassAnnotation;
import org.springframework.cloud.contract.verifier.builder.JUnit5OrderClassAnnotation;
import org.springframework.cloud.contract.verifier.builder.SpockOrderClassAnnotation;
import org.springframework.cloud.contract.verifier.builder.SuppressWarningsClassAnnotation;

class ClassAnnotationsBuilder {
    private final GeneratedTestClassBuilder parentBuilder;
    private final BlockBuilder builder;
    private final GeneratedClassMetaData metaData;

    ClassAnnotationsBuilder(GeneratedTestClassBuilder generatedTestClassBuilder) {
        this.parentBuilder = generatedTestClassBuilder;
        this.builder = generatedTestClassBuilder.blockBuilder;
        this.metaData = generatedTestClassBuilder.generatedClassMetaData;
    }

    ClassAnnotationsBuilder defaultAnnotations() {
        this.parentBuilder.classAnnotations(new SuppressWarningsClassAnnotation(this.builder));
        return this;
    }

    ClassAnnotationsBuilder jUnit4() {
        this.parentBuilder.classAnnotations(new JUnit4OrderClassAnnotation(this.builder, this.metaData));
        return this;
    }

    ClassAnnotationsBuilder jUnit5() {
        this.parentBuilder.classAnnotations(new JUnit5OrderClassAnnotation(this.builder, this.metaData));
        return this;
    }

    ClassAnnotationsBuilder spock() {
        this.parentBuilder.classAnnotations(new SpockOrderClassAnnotation(this.builder, this.metaData));
        return this;
    }

    GeneratedTestClassBuilder build() {
        return this.parentBuilder;
    }
}

