/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.http;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.springframework.cloud.contract.verifier.http.HttpVerifier;
import org.springframework.cloud.contract.verifier.http.Request;
import org.springframework.cloud.contract.verifier.http.Response;

public class OkHttpHttpVerifier
implements HttpVerifier {
    private final String hostAndPort;

    public OkHttpHttpVerifier(String hostAndPort) {
        this.hostAndPort = hostAndPort;
    }

    @Override
    public Response exchange(Request request) {
        Response response;
        block9: {
            String requestContentType = request.contentType();
            OkHttpClient client = new OkHttpClient.Builder().protocols(this.toProtocol(request.protocol().toString())).build();
            Map<String, String> headers = this.stringTyped(request.headers());
            if (!request.cookies().isEmpty()) {
                headers.put("Set-Cookie", request.cookies().entrySet().stream().map(e -> (String)e.getKey() + "=" + e.getValue().toString()).collect(Collectors.joining(";")));
            }
            okhttp3.Request req = new Request.Builder().url(this.url(request)).method(request.method().name(), this.requestBody(request, requestContentType)).headers(Headers.of(headers)).build();
            okhttp3.Response res = client.newCall(req).execute();
            try {
                response = this.response(res);
                if (res == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e2) {
                    throw new IllegalStateException(e2);
                }
            }
            res.close();
        }
        return response;
    }

    private String url(Request request) {
        String url = request.scheme().name().toLowerCase() + ":" + this.hostAndPort + (request.path().startsWith("/") ? request.path() : "/" + request.path());
        if (!request.queryParams().isEmpty()) {
            return url + "?" + request.queryParams().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining("&"));
        }
        return url;
    }

    private List<Protocol> toProtocol(String string) {
        try {
            Protocol protocol = Protocol.get((String)string);
            switch (protocol) {
                case HTTP_1_0: 
                case HTTP_2: 
                case QUIC: {
                    return Arrays.asList(protocol, Protocol.HTTP_1_1);
                }
                case HTTP_1_1: {
                    return Collections.singletonList(Protocol.HTTP_1_1);
                }
                case H2_PRIOR_KNOWLEDGE: {
                    return Collections.singletonList(Protocol.H2_PRIOR_KNOWLEDGE);
                }
            }
            return Collections.emptyList();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private Response response(okhttp3.Response res) throws IOException {
        byte[] responseBody = this.responseBody(res);
        return Response.builder().body(responseBody).statusCode(res.code()).headers(this.withSingleHeader(res)).cookies(res.headers().values("Set-Cookie").stream().flatMap(s -> Arrays.stream(s.split(";"))).map(s -> {
            String[] singleCookie = s.split("=");
            return new AbstractMap.SimpleEntry<String, String>(singleCookie[0], singleCookie.length > 1 ? singleCookie[1] : "");
        }).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue, (a, b) -> a, HashMap::new))).build();
    }

    private RequestBody requestBody(Request request, String requestContentType) {
        if (request.body() == null) {
            return null;
        }
        byte[] bodyArray = request.body().asByteArray();
        return RequestBody.create((MediaType)MediaType.parse((String)requestContentType), (byte[])bodyArray);
    }

    private byte[] responseBody(okhttp3.Response res) throws IOException {
        return res.body() != null ? res.body().bytes() : null;
    }

    private Map<String, Object> withSingleHeader(okhttp3.Response res) {
        return res.headers().toMultimap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((List)e.getValue()).get(0), (a, b) -> a, HashMap::new));
    }

    private Map<String, String> stringTyped(Map<String, Object> headers) {
        return headers.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> e.getValue().toString()));
    }
}

