/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.builder;

import java.util.Iterator;
import org.springframework.cloud.contract.spec.internal.DslProperty;
import org.springframework.cloud.contract.spec.internal.ExecutionProperty;
import org.springframework.cloud.contract.spec.internal.MatchingStrategy;
import org.springframework.cloud.contract.spec.internal.QueryParameter;
import org.springframework.cloud.contract.spec.internal.QueryParameters;
import org.springframework.cloud.contract.spec.internal.Request;
import org.springframework.cloud.contract.verifier.builder.BlockBuilder;
import org.springframework.cloud.contract.verifier.builder.BodyParser;
import org.springframework.cloud.contract.verifier.builder.GeneratedClassMetaData;
import org.springframework.cloud.contract.verifier.builder.JaxRsAcceptor;
import org.springframework.cloud.contract.verifier.builder.MethodVisitor;
import org.springframework.cloud.contract.verifier.builder.QueryParamsResolver;
import org.springframework.cloud.contract.verifier.builder.When;
import org.springframework.cloud.contract.verifier.file.SingleContractMetadata;
import org.springframework.cloud.contract.verifier.util.MapConverter;

class JaxRsUrlPathWhen
implements When,
JaxRsAcceptor,
QueryParamsResolver {
    private final BlockBuilder blockBuilder;
    private final GeneratedClassMetaData generatedClassMetaData;
    private final BodyParser bodyParser;

    JaxRsUrlPathWhen(BlockBuilder blockBuilder, GeneratedClassMetaData metaData, BodyParser bodyParser) {
        this.blockBuilder = blockBuilder;
        this.generatedClassMetaData = metaData;
        this.bodyParser = bodyParser;
    }

    @Override
    public MethodVisitor<When> apply(SingleContractMetadata metadata) {
        this.appendUrlPathAndQueryParameters(metadata.getContract().getRequest());
        return this;
    }

    private void appendUrlPathAndQueryParameters(Request request) {
        if (request.getUrl() != null) {
            this.blockBuilder.addIndented(".path(" + this.concreteUrl((DslProperty)request.getUrl()) + ")");
            this.appendQueryParams(request.getUrl().getQueryParameters());
        } else if (request.getUrlPath() != null) {
            this.blockBuilder.addIndented(".path(" + this.concreteUrl((DslProperty)request.getUrlPath()) + ")");
            this.appendQueryParams(request.getUrlPath().getQueryParameters());
        }
    }

    private String concreteUrl(DslProperty url) {
        Object testSideUrl = MapConverter.getTestSideValues(url);
        if (!(testSideUrl instanceof ExecutionProperty)) {
            return '\"' + testSideUrl.toString() + '\"';
        }
        return testSideUrl.toString();
    }

    private void appendQueryParams(QueryParameters queryParameters) {
        if (queryParameters == null || queryParameters.getParameters().isEmpty()) {
            return;
        }
        this.blockBuilder.addEmptyLine();
        Iterator iterator = queryParameters.getParameters().stream().filter(this::allowedQueryParameter).iterator();
        while (iterator.hasNext()) {
            QueryParameter param = (QueryParameter)iterator.next();
            String text = ".queryParam(\"" + param.getName() + "\", " + this.bodyParser.quotedShortText(this.resolveParamValue(param)) + ")";
            if (iterator.hasNext()) {
                this.blockBuilder.addLine(text);
                continue;
            }
            this.blockBuilder.addIndented(text);
        }
    }

    private boolean allowedQueryParameter(QueryParameter param) {
        return this.allowedQueryParameter(param.getServerValue());
    }

    private boolean allowedQueryParameter(MatchingStrategy matchingStrategy) {
        return matchingStrategy.getType() != MatchingStrategy.Type.ABSENT;
    }

    private boolean allowedQueryParameter(Object o) {
        if (o instanceof QueryParameter) {
            return this.allowedQueryParameter((QueryParameter)o);
        }
        if (o instanceof MatchingStrategy) {
            return this.allowedQueryParameter((MatchingStrategy)o);
        }
        if (o instanceof DslProperty) {
            return this.allowedQueryParameter(((DslProperty)o).getServerValue());
        }
        return true;
    }

    @Override
    public boolean accept(SingleContractMetadata metadata) {
        return this.acceptType(this.generatedClassMetaData, metadata);
    }
}

