/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.messaging.internal;

import java.util.Map;
import org.springframework.cloud.contract.verifier.messaging.MessageVerifier;
import org.springframework.cloud.contract.verifier.messaging.internal.ContractVerifierMessage;

public class ContractVerifierMessaging<M> {
    private final MessageVerifier<M> exchange;

    public ContractVerifierMessaging(MessageVerifier<M> exchange) {
        this.exchange = exchange;
    }

    public void send(ContractVerifierMessage message, String destination) {
        this.exchange.send(message.getPayload(), message.getHeaders(), destination);
    }

    public ContractVerifierMessage receive(String destination) {
        return this.convert(this.exchange.receive(destination));
    }

    public <T> ContractVerifierMessage create(T payload, Map<String, Object> headers) {
        return new ContractVerifierMessage(payload, headers);
    }

    protected ContractVerifierMessage convert(M receive) {
        return new ContractVerifierMessage(receive, null);
    }
}

