/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.messaging.amqp;

import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageBuilder;
import org.springframework.amqp.core.MessageListener;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.core.MessagePropertiesBuilder;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.rabbit.listener.SimpleMessageListenerContainer;
import org.springframework.amqp.rabbit.support.CorrelationData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.contract.verifier.messaging.MessageVerifier;
import org.springframework.cloud.contract.verifier.messaging.amqp.MessageListenerAccessor;
import org.springframework.util.Assert;

public class SpringAmqpStubMessages
implements MessageVerifier<Message> {
    private static final Logger log = LoggerFactory.getLogger(SpringAmqpStubMessages.class);
    private final RabbitTemplate rabbitTemplate;
    private final MessageListenerAccessor messageListenerAccessor;

    @Autowired
    public SpringAmqpStubMessages(RabbitTemplate rabbitTemplate, MessageListenerAccessor messageListenerAccessor) {
        Assert.notNull((Object)rabbitTemplate);
        Assert.isTrue((Mockito.mockingDetails((Object)rabbitTemplate).isSpy() || Mockito.mockingDetails((Object)rabbitTemplate).isMock() ? 1 : 0) != 0);
        this.rabbitTemplate = rabbitTemplate;
        this.messageListenerAccessor = messageListenerAccessor;
    }

    @Override
    public <T> void send(T payload, Map<String, Object> headers, String destination) {
        Message message = MessageBuilder.withBody((byte[])((String)payload).getBytes()).andProperties((MessageProperties)MessagePropertiesBuilder.newInstance().setContentType(this.header(headers, "contentType")).copyHeaders(headers).build()).build();
        if (headers != null && headers.containsKey("__TypeId__")) {
            message.getMessageProperties().setHeader("__TypeId__", headers.get("__TypeId__"));
        }
        if (headers != null && headers.containsKey("amqp_receivedRoutingKey")) {
            message.getMessageProperties().setReceivedRoutingKey(this.header(headers, "amqp_receivedRoutingKey"));
        }
        this.send(message, destination);
    }

    private String header(Map<String, Object> headers, String headerName) {
        if (headers == null) {
            return "";
        }
        Object value = headers.get(headerName);
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Iterable) {
            Iterable values = (Iterable)value;
            return values.iterator().hasNext() ? (String)values.iterator().next() : "";
        }
        return value.toString();
    }

    @Override
    public void send(Message message, String destination) {
        String routingKey = message.getMessageProperties().getReceivedRoutingKey();
        List<SimpleMessageListenerContainer> listenerContainers = this.messageListenerAccessor.getListenerContainersForDestination(destination, routingKey);
        if (listenerContainers.isEmpty()) {
            throw new IllegalStateException("no listeners found for destination " + destination);
        }
        for (SimpleMessageListenerContainer listenerContainer : listenerContainers) {
            MessageListener messageListener = (MessageListener)listenerContainer.getMessageListener();
            messageListener.onMessage(message);
        }
    }

    @Override
    public Message receive(String destination, long timeout, TimeUnit timeUnit) {
        ArgumentCaptor messageCaptor = ArgumentCaptor.forClass(Message.class);
        ArgumentCaptor routingKeyCaptor = ArgumentCaptor.forClass(String.class);
        ((RabbitTemplate)Mockito.verify((Object)this.rabbitTemplate, (VerificationMode)Mockito.atLeastOnce())).send((String)Matchers.eq((Object)destination), (String)routingKeyCaptor.capture(), (Message)messageCaptor.capture(), (CorrelationData)Matchers.any(CorrelationData.class));
        if (messageCaptor.getAllValues().isEmpty()) {
            log.info("no messages found on destination {}", (Object)destination);
            return null;
        }
        if (messageCaptor.getAllValues().size() > 1) {
            log.info("multiple messages found on destination {} returning last one - {}", (Object)destination);
            return (Message)messageCaptor.getValue();
        }
        Message message = (Message)messageCaptor.getValue();
        if (!((String)routingKeyCaptor.getValue()).isEmpty()) {
            log.info("routing key passed  {}", routingKeyCaptor.getValue());
            message.getMessageProperties().setReceivedRoutingKey((String)routingKeyCaptor.getValue());
        }
        return message;
    }

    @Override
    public Message receive(String destination) {
        return this.receive(destination, 5L, TimeUnit.SECONDS);
    }
}

