/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.AbstractMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.contract.stubrunner.FileWalker;
import org.springframework.cloud.contract.stubrunner.GitContractsRepo;
import org.springframework.cloud.contract.stubrunner.StubConfiguration;
import org.springframework.cloud.contract.stubrunner.StubDownloader;
import org.springframework.cloud.contract.stubrunner.StubRunnerOptions;
import org.springframework.cloud.contract.stubrunner.TemporaryFileStorage;
import org.springframework.core.io.Resource;

class GitStubDownloader
implements StubDownloader {
    private static final Log log = LogFactory.getLog(GitStubDownloader.class);
    private static final Class CLAZZ = TemporaryFileStorage.class;
    private final StubRunnerOptions stubRunnerOptions;
    private final boolean deleteStubsAfterTest;
    private final GitContractsRepo gitContractsRepo;

    GitStubDownloader(StubRunnerOptions stubRunnerOptions) {
        this.stubRunnerOptions = stubRunnerOptions;
        this.deleteStubsAfterTest = this.stubRunnerOptions.isDeleteStubsAfterTest();
        this.gitContractsRepo = new GitContractsRepo(stubRunnerOptions);
        this.registerShutdownHook();
    }

    @Override
    public Map.Entry<StubConfiguration, File> downloadAndUnpackStubJar(StubConfiguration stubConfiguration) {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Trying to find a contract for [" + stubConfiguration.toColonSeparatedDependencyNotation() + "]"));
            }
            Resource repo = this.stubRunnerOptions.getStubRepositoryRoot();
            File clonedRepo = this.gitContractsRepo.clonedRepo(repo);
            FileWalker walker = new FileWalker(stubConfiguration);
            Files.walkFileTree(clonedRepo.toPath(), walker);
            if (walker.foundFile != null) {
                return new AbstractMap.SimpleEntry<StubConfiguration, File>(stubConfiguration, walker.foundFile.toFile());
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        if (log.isWarnEnabled()) {
            log.warn((Object)("No matching contracts were found in the repo for [" + stubConfiguration.toColonSeparatedDependencyNotation() + "]"));
        }
        return null;
    }

    private void registerShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> TemporaryFileStorage.cleanup(this.deleteStubsAfterTest)));
    }
}

