/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner.spring.cloud;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.contract.stubrunner.StubFinder;
import org.springframework.cloud.contract.stubrunner.spring.cloud.ConditionalOnStubbedDiscoveryEnabled;
import org.springframework.cloud.contract.stubrunner.spring.cloud.StubMapperProperties;
import org.springframework.cloud.contract.stubrunner.spring.cloud.StubRunnerDiscoveryClient;
import org.springframework.cloud.contract.stubrunner.spring.cloud.StubRunnerDiscoveryClientWrapper;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={StubMapperProperties.class})
@ConditionalOnClass(value={DiscoveryClient.class})
@ConditionalOnProperty(value={"stubrunner.cloud.enabled"}, matchIfMissing=true)
public class StubRunnerSpringCloudAutoConfiguration {
    @Autowired
    BeanFactory beanFactory;

    @Bean
    public StubRunnerDiscoveryClientWrapper stubRunnerDiscoveryClientWrapper() {
        return new StubRunnerDiscoveryClientWrapper(this.beanFactory);
    }

    @Bean
    @ConditionalOnMissingBean(value={DiscoveryClient.class})
    @ConditionalOnStubbedDiscoveryEnabled
    @ConditionalOnProperty(value={"stubrunner.cloud.delegate.enabled"}, havingValue="false", matchIfMissing=true)
    public DiscoveryClient noOpStubRunnerDiscoveryClient(StubFinder stubFinder, StubMapperProperties stubMapperProperties, @Value(value="${spring.application.name:unknown}") String springAppName) {
        return new StubRunnerDiscoveryClient(stubFinder, stubMapperProperties, springAppName);
    }
}

