/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner;

import java.util.Collections;
import java.util.List;
import org.springframework.cloud.contract.stubrunner.StubDownloader;
import org.springframework.cloud.contract.stubrunner.StubDownloaderBuilder;
import org.springframework.cloud.contract.stubrunner.StubRunnerOptions;
import org.springframework.cloud.contract.stubrunner.StubsResource;
import org.springframework.cloud.contract.stubrunner.StubsStubDownloader;
import org.springframework.cloud.contract.stubrunner.spring.StubRunnerProperties;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.StringUtils;

public class FileStubDownloader
implements StubDownloaderBuilder {
    private static final List<String> ACCEPTABLE_PROTOCOLS = Collections.singletonList("stubs");

    public static boolean isProtocolAccepted(String url) {
        return ACCEPTABLE_PROTOCOLS.stream().anyMatch(url::startsWith);
    }

    @Override
    public StubDownloader build(StubRunnerOptions stubRunnerOptions) {
        if (stubRunnerOptions.getStubsMode() == StubRunnerProperties.StubsMode.CLASSPATH || stubRunnerOptions.getStubRepositoryRoot() == null) {
            return null;
        }
        Resource resource = stubRunnerOptions.getStubRepositoryRoot();
        if (!(resource instanceof StubsResource)) {
            return null;
        }
        return new StubsStubDownloader(stubRunnerOptions);
    }

    @Override
    public Resource resolve(String location, ResourceLoader resourceLoader) {
        if (StringUtils.isEmpty((Object)location) || !FileStubDownloader.isProtocolAccepted(location)) {
            return null;
        }
        return new StubsResource(location);
    }
}

