/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner;

import com.jcraft.jsch.IdentityRepository;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.agentproxy.AgentProxyException;
import com.jcraft.jsch.agentproxy.Connector;
import com.jcraft.jsch.agentproxy.RemoteIdentityRepository;
import com.jcraft.jsch.agentproxy.USocketFactory;
import com.jcraft.jsch.agentproxy.connector.SSHAgentConnector;
import com.jcraft.jsch.agentproxy.usocket.JNAUSocketFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.TransportConfigCallback;
import org.eclipse.jgit.api.errors.EmptyCommitException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.JschConfigSessionFactory;
import org.eclipse.jgit.transport.OpenSshConfig;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.SshTransport;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.contract.stubrunner.GitStubDownloaderProperties;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;

class GitRepo {
    private static final Log log = LogFactory.getLog(GitRepo.class);
    final JGitFactory gitFactory;
    private final File basedir;

    GitRepo(File basedir, GitStubDownloaderProperties properties) {
        this.basedir = basedir;
        this.gitFactory = new JGitFactory(properties);
    }

    @Deprecated
    GitRepo(File basedir) {
        this.basedir = basedir;
        this.gitFactory = new JGitFactory();
    }

    @Deprecated
    GitRepo(File basedir, JGitFactory factory) {
        this.basedir = basedir;
        this.gitFactory = factory;
    }

    File cloneProject(URI projectUri) {
        try {
            log.info((Object)("Cloning repo from [" + projectUri + "] to [" + this.basedir + "]"));
            Git git = this.cloneToBasedir(projectUri, this.basedir);
            if (git != null) {
                git.close();
            }
            File clonedRepo = git.getRepository().getWorkTree();
            log.info((Object)("Cloned repo to [" + clonedRepo + "]"));
            return clonedRepo;
        }
        catch (Exception e) {
            throw new IllegalStateException("Exception occurred while cloning repo", e);
        }
    }

    void checkout(File project, String branch) {
        try {
            String currentBranch = this.currentBranch(project);
            if (currentBranch.equals(branch)) {
                log.info((Object)"Won't check out the same branch. Skipping");
                return;
            }
            log.info((Object)("Checking out branch [" + branch + "]"));
            this.checkoutBranch(project, branch);
            log.info((Object)("Successfully checked out the branch [" + branch + "]"));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    void pull(File project) {
        try (Git git = this.gitFactory.open(project);){
            PullCommand command = this.gitFactory.pull(git);
            command.setRebase(true).call();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    CommitResult commit(File project, String message) {
        try (Git git = this.gitFactory.open(this.file(project));){
            git.add().addFilepattern(".").call();
            git.commit().setAllowEmpty(false).setMessage(message).call();
            log.info((Object)("Commited successfully with message [" + message + "]"));
            CommitResult commitResult = CommitResult.SUCCESSFUL;
            return commitResult;
        }
        catch (EmptyCommitException e) {
            log.info((Object)"There were no changes detected. Will not commit an empty commit");
            return CommitResult.EMPTY;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    void reset(File project) {
        try (Git git = this.gitFactory.open(this.file(project));){
            git.reset().setMode(ResetCommand.ResetType.HARD).call();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    void pushCurrentBranch(File project) {
        try (Git git = this.gitFactory.open(this.file(project));){
            this.gitFactory.push(git).call();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private File file(File project) throws FileNotFoundException {
        return ResourceUtils.getFile((URI)project.toURI()).getAbsoluteFile();
    }

    private Git cloneToBasedir(URI projectUrl, File destinationFolder) {
        String projectGitUrl;
        String url = projectUrl.toString();
        String string = projectGitUrl = url.endsWith(".git") ? url : url + ".git";
        if (log.isDebugEnabled()) {
            log.debug((Object)("Project git url [" + projectGitUrl + "]"));
        }
        CloneCommand command = this.gitFactory.getCloneCommandByCloneRepository().setURI(projectGitUrl).setDirectory(destinationFolder);
        try {
            Git git = command.call();
            if (git.getRepository().getRemoteNames().isEmpty()) {
                log.info((Object)"No remote added. Will add remote of the cloned project");
                git.remoteSetUrl().setUri(new URIish(projectGitUrl));
                git.remoteSetUrl().setName("origin");
                git.remoteSetUrl().setPush(true);
            }
            return git;
        }
        catch (URISyntaxException | GitAPIException e) {
            this.deleteBaseDirIfExists();
            throw new IllegalStateException(e);
        }
    }

    private Ref checkoutBranch(File projectDir, String branch) throws GitAPIException {
        Git git = this.gitFactory.open(projectDir);
        CheckoutCommand command = git.checkout().setName(branch);
        try {
            if (this.shouldTrack(git, branch)) {
                this.trackBranch(command, branch);
            }
            Ref ref = command.call();
            return ref;
        }
        catch (GitAPIException e) {
            this.deleteBaseDirIfExists();
            throw e;
        }
        finally {
            git.close();
        }
    }

    private String currentBranch(File projectDir) {
        try (Git git = this.gitFactory.open(projectDir);){
            String string = git.getRepository().getBranch();
            return string;
        }
    }

    private boolean shouldTrack(Git git, String label) throws GitAPIException {
        return this.isBranch(git, label) && !this.isLocalBranch(git, label);
    }

    private void trackBranch(CheckoutCommand checkout, String label) {
        checkout.setCreateBranch(true).setName(label).setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.TRACK).setStartPoint("origin/" + label);
    }

    private boolean isBranch(Git git, String label) throws GitAPIException {
        return this.containsBranch(git, label, ListBranchCommand.ListMode.ALL);
    }

    private boolean isLocalBranch(Git git, String label) throws GitAPIException {
        return this.containsBranch(git, label, null);
    }

    private boolean containsBranch(Git git, String label, ListBranchCommand.ListMode listMode) throws GitAPIException {
        ListBranchCommand command = git.branchList();
        if (listMode != null) {
            command.setListMode(listMode);
        }
        List branches = command.call();
        for (Ref ref : branches) {
            if (!ref.getName().endsWith("/" + label)) continue;
            return true;
        }
        return false;
    }

    private void deleteBaseDirIfExists() {
        if (this.basedir.exists()) {
            try {
                FileUtils.delete((File)this.basedir, (int)1);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to initialize base directory", e);
            }
        }
    }

    static class JGitFactory {
        private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        final CredentialsProvider provider;
        private final JschConfigSessionFactory factory = new JschConfigSessionFactory(this){
            final /* synthetic */ JGitFactory this$0;
            {
                this.this$0 = this$0;
            }

            protected void configure(OpenSshConfig.Host host, Session session) {
            }

            protected JSch createDefaultJSch(FS fs) throws JSchException {
                SSHAgentConnector connector = null;
                try {
                    if (SSHAgentConnector.isConnectorAvailable()) {
                        JNAUSocketFactory usf = new JNAUSocketFactory();
                        connector = new SSHAgentConnector((USocketFactory)usf);
                    }
                    log.info("Successfully connected to an agent");
                }
                catch (AgentProxyException e) {
                    log.error("Exception occurred while trying to connect to agent. Will createthe default JSch connection", (Throwable)e);
                    return super.createDefaultJSch(fs);
                }
                JSch jsch = super.createDefaultJSch(fs);
                if (connector != null) {
                    JSch.setConfig((String)"PreferredAuthentications", (String)"publickey,password");
                    RemoteIdentityRepository identityRepository = new RemoteIdentityRepository((Connector)connector);
                    jsch.setIdentityRepository((IdentityRepository)identityRepository);
                }
                return jsch;
            }
        };
        private final TransportConfigCallback callback = transport -> {
            if (transport instanceof SshTransport) {
                SshTransport sshTransport = (SshTransport)transport;
                sshTransport.setSshSessionFactory((SshSessionFactory)this.factory);
            }
        };

        JGitFactory(GitStubDownloaderProperties properties) {
            if (StringUtils.hasText((String)properties.username)) {
                log.info("Passed username and password - will set a custom credentials provider");
                this.provider = this.credentialsProvider(properties);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("No custom credentials provider will be set");
                }
                this.provider = null;
            }
        }

        JGitFactory() {
            this.provider = null;
        }

        CredentialsProvider credentialsProvider(GitStubDownloaderProperties properties) {
            return new UsernamePasswordCredentialsProvider(properties.username, properties.password);
        }

        CloneCommand getCloneCommandByCloneRepository() {
            return (CloneCommand)((CloneCommand)Git.cloneRepository().setCredentialsProvider(this.provider)).setTransportConfigCallback(this.callback);
        }

        PushCommand push(Git git) {
            return (PushCommand)((PushCommand)git.push().setCredentialsProvider(this.provider)).setTransportConfigCallback(this.callback);
        }

        PullCommand pull(Git git) {
            return (PullCommand)((PullCommand)git.pull().setCredentialsProvider(this.provider)).setTransportConfigCallback(this.callback);
        }

        Git open(File file) {
            try {
                return Git.open((File)file);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    static enum CommitResult {
        SUCCESSFUL,
        EMPTY;

    }
}

