/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.spec.internal;

import java.io.File;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.cloud.contract.spec.internal.Body;
import org.springframework.cloud.contract.spec.internal.ClientDslProperty;
import org.springframework.cloud.contract.spec.internal.DslProperty;
import org.springframework.cloud.contract.spec.internal.ExecutionProperty;
import org.springframework.cloud.contract.spec.internal.FromFileProperty;
import org.springframework.cloud.contract.spec.internal.NamedProperty;
import org.springframework.cloud.contract.spec.internal.OptionalProperty;
import org.springframework.cloud.contract.spec.internal.RegexPatterns;
import org.springframework.cloud.contract.spec.internal.RegexProperty;
import org.springframework.cloud.contract.spec.internal.ServerDslProperty;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b'\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010,\u001a\u00020-2\b\u0010.\u001a\u0004\u0018\u00010\u0001J\u0010\u0010/\u001a\u00020-2\b\u0010.\u001a\u0004\u0018\u00010\u0001J\u0010\u00100\u001a\u00020-2\b\u0010.\u001a\u0004\u0018\u00010\u0001J\u0010\u00101\u001a\u00020-2\b\u0010.\u001a\u0004\u0018\u00010\u0001J\u0010\u00102\u001a\u0002032\b\u00104\u001a\u0004\u0018\u00010\u0001J\u0010\u00105\u001a\u0002032\b\u00104\u001a\u0004\u0018\u00010\u0001J\u0010\u00106\u001a\u0002032\b\u00104\u001a\u0004\u0018\u00010\u0001J\u0010\u00107\u001a\u0002032\b\u00104\u001a\u0004\u0018\u00010\u0001J\u0010\u00108\u001a\u0002092\b\u0010:\u001a\u0004\u0018\u00010\u0001J\u000e\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020>J\u000e\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020>J\u0016\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020>2\u0006\u0010B\u001a\u00020CJ\u000e\u0010D\u001a\u00020@2\u0006\u0010A\u001a\u00020>J\u000e\u0010E\u001a\u00020F2\u0006\u0010A\u001a\u00020>J\u0016\u0010E\u001a\u00020F2\u0006\u0010A\u001a\u00020>2\u0006\u0010B\u001a\u00020CJ\u000e\u0010G\u001a\u00020F2\u0006\u0010A\u001a\u00020>J\u0010\u0010H\u001a\u00020I2\u0006\u0010A\u001a\u00020>H\u0002J\"\u0010J\u001a\u00020K2\f\u0010L\u001a\b\u0012\u0004\u0012\u00020\u00010M2\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00010MJ0\u0010J\u001a\u00020K2\f\u0010L\u001a\b\u0012\u0004\u0012\u00020\u00010M2\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00010M2\f\u0010N\u001a\b\u0012\u0004\u0012\u00020\u00010MJ \u0010J\u001a\u00020K2\u0018\u0010O\u001a\u0014\u0012\u0004\u0012\u00020>\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010M0PJ\u000e\u0010Q\u001a\u00020\u00052\u0006\u0010:\u001a\u00020\u0001J\u000e\u0010R\u001a\u00020\u00052\u0006\u0010R\u001a\u00020>J\u000e\u0010R\u001a\u00020\u00052\u0006\u0010R\u001a\u00020SJ\u000e\u0010R\u001a\u00020\u00052\u0006\u0010R\u001a\u00020\u0005R\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0007R\u0011\u0010\u000e\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0007R\u0011\u0010\u0010\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0007R\u0011\u0010\u0012\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0007R\u0011\u0010\u0014\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0007R\u0011\u0010\u0016\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0007R\u0011\u0010\u0018\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0007R\u0011\u0010\u001a\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0007R\u0011\u0010\u001c\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0007R\u0011\u0010\u001e\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0007R\u0011\u0010 \u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0007R\u0011\u0010\"\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0007R\u0011\u0010$\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0007R\u0011\u0010&\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u0007R\u0011\u0010(\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u0007R\u0011\u0010*\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u0007\u00a8\u0006T"}, d2={"Lorg/springframework/cloud/contract/spec/internal/CommonDsl;", "", "<init>", "()V", "onlyAlphaUnicode", "Lorg/springframework/cloud/contract/spec/internal/RegexProperty;", "getOnlyAlphaUnicode", "()Lorg/springframework/cloud/contract/spec/internal/RegexProperty;", "alphaNumeric", "getAlphaNumeric", "number", "getNumber", "positiveInt", "getPositiveInt", "anyBoolean", "getAnyBoolean", "anInteger", "getAnInteger", "aDouble", "getADouble", "ipAddress", "getIpAddress", "hostname", "getHostname", "email", "getEmail", "anUrl", "getAnUrl", "anHttpsUrl", "getAnHttpsUrl", "uuid", "getUuid", "isoDate", "getIsoDate", "isoDateTime", "getIsoDateTime", "isoTime", "getIsoTime", "iso8601WithOffset", "getIso8601WithOffset", "nonEmpty", "getNonEmpty", "nonBlank", "getNonBlank", "client", "Lorg/springframework/cloud/contract/spec/internal/ClientDslProperty;", "clientValue", "c", "consumer", "stub", "server", "Lorg/springframework/cloud/contract/spec/internal/ServerDslProperty;", "serverValue", "p", "producer", "test", "optional", "Lorg/springframework/cloud/contract/spec/internal/OptionalProperty;", "value", "execute", "Lorg/springframework/cloud/contract/spec/internal/ExecutionProperty;", "commandToExecute", "", "file", "Lorg/springframework/cloud/contract/spec/internal/FromFileProperty;", "relativePath", "charset", "Ljava/nio/charset/Charset;", "fileAsBytes", "bodyFromFile", "Lorg/springframework/cloud/contract/spec/internal/Body;", "bodyFromFileAsBytes", "fileLocation", "Ljava/io/File;", "named", "Lorg/springframework/cloud/contract/spec/internal/NamedProperty;", "name", "Lorg/springframework/cloud/contract/spec/internal/DslProperty;", "contentType", "namedMap", "", "regexProperty", "regex", "Ljava/util/regex/Pattern;", "spring-cloud-contract-spec-kotlin"})
public class CommonDsl {
    @NotNull
    public final RegexProperty getOnlyAlphaUnicode() {
        RegexProperty regexProperty = RegexPatterns.onlyAlphaUnicode();
        Intrinsics.checkNotNullExpressionValue((Object)regexProperty, (String)"onlyAlphaUnicode(...)");
        return regexProperty;
    }

    @NotNull
    public final RegexProperty getAlphaNumeric() {
        RegexProperty regexProperty = RegexPatterns.alphaNumeric();
        Intrinsics.checkNotNullExpressionValue((Object)regexProperty, (String)"alphaNumeric(...)");
        return regexProperty;
    }

    @NotNull
    public final RegexProperty getNumber() {
        RegexProperty regexProperty = RegexPatterns.number();
        Intrinsics.checkNotNullExpressionValue((Object)regexProperty, (String)"number(...)");
        return regexProperty;
    }

    @NotNull
    public final RegexProperty getPositiveInt() {
        RegexProperty regexProperty = RegexPatterns.positiveInt();
        Intrinsics.checkNotNullExpressionValue((Object)regexProperty, (String)"positiveInt(...)");
        return regexProperty;
    }

    @NotNull
    public final RegexProperty getAnyBoolean() {
        RegexProperty regexProperty = RegexPatterns.anyBoolean();
        Intrinsics.checkNotNullExpressionValue((Object)regexProperty, (String)"anyBoolean(...)");
        return regexProperty;
    }

    @NotNull
    public final RegexProperty getAnInteger() {
        RegexProperty regexProperty = RegexPatterns.anInteger();
        Intrinsics.checkNotNullExpressionValue((Object)regexProperty, (String)"anInteger(...)");
        return regexProperty;
    }

    @NotNull
    public final RegexProperty getADouble() {
        RegexProperty regexProperty = RegexPatterns.aDouble();
        Intrinsics.checkNotNullExpressionValue((Object)regexProperty, (String)"aDouble(...)");
        return regexProperty;
    }

    @NotNull
    public final RegexProperty getIpAddress() {
        RegexProperty regexProperty = RegexPatterns.ipAddress();
        Intrinsics.checkNotNullExpressionValue((Object)regexProperty, (String)"ipAddress(...)");
        return regexProperty;
    }

    @NotNull
    public final RegexProperty getHostname() {
        RegexProperty regexProperty = RegexPatterns.hostname();
        Intrinsics.checkNotNullExpressionValue((Object)regexProperty, (String)"hostname(...)");
        return regexProperty;
    }

    @NotNull
    public final RegexProperty getEmail() {
        RegexProperty regexProperty = RegexPatterns.email();
        Intrinsics.checkNotNullExpressionValue((Object)regexProperty, (String)"email(...)");
        return regexProperty;
    }

    @NotNull
    public final RegexProperty getAnUrl() {
        RegexProperty regexProperty = RegexPatterns.url();
        Intrinsics.checkNotNullExpressionValue((Object)regexProperty, (String)"url(...)");
        return regexProperty;
    }

    @NotNull
    public final RegexProperty getAnHttpsUrl() {
        RegexProperty regexProperty = RegexPatterns.httpsUrl();
        Intrinsics.checkNotNullExpressionValue((Object)regexProperty, (String)"httpsUrl(...)");
        return regexProperty;
    }

    @NotNull
    public final RegexProperty getUuid() {
        RegexProperty regexProperty = RegexPatterns.uuid();
        Intrinsics.checkNotNullExpressionValue((Object)regexProperty, (String)"uuid(...)");
        return regexProperty;
    }

    @NotNull
    public final RegexProperty getIsoDate() {
        RegexProperty regexProperty = RegexPatterns.isoDate();
        Intrinsics.checkNotNullExpressionValue((Object)regexProperty, (String)"isoDate(...)");
        return regexProperty;
    }

    @NotNull
    public final RegexProperty getIsoDateTime() {
        RegexProperty regexProperty = RegexPatterns.isoDateTime();
        Intrinsics.checkNotNullExpressionValue((Object)regexProperty, (String)"isoDateTime(...)");
        return regexProperty;
    }

    @NotNull
    public final RegexProperty getIsoTime() {
        RegexProperty regexProperty = RegexPatterns.isoTime();
        Intrinsics.checkNotNullExpressionValue((Object)regexProperty, (String)"isoTime(...)");
        return regexProperty;
    }

    @NotNull
    public final RegexProperty getIso8601WithOffset() {
        RegexProperty regexProperty = RegexPatterns.iso8601WithOffset();
        Intrinsics.checkNotNullExpressionValue((Object)regexProperty, (String)"iso8601WithOffset(...)");
        return regexProperty;
    }

    @NotNull
    public final RegexProperty getNonEmpty() {
        RegexProperty regexProperty = RegexPatterns.nonEmpty();
        Intrinsics.checkNotNullExpressionValue((Object)regexProperty, (String)"nonEmpty(...)");
        return regexProperty;
    }

    @NotNull
    public final RegexProperty getNonBlank() {
        RegexProperty regexProperty = RegexPatterns.nonBlank();
        Intrinsics.checkNotNullExpressionValue((Object)regexProperty, (String)"nonBlank(...)");
        return regexProperty;
    }

    @NotNull
    public final ClientDslProperty client(@Nullable Object clientValue) {
        return new ClientDslProperty(clientValue);
    }

    @NotNull
    public final ClientDslProperty c(@Nullable Object clientValue) {
        return new ClientDslProperty(clientValue);
    }

    @NotNull
    public final ClientDslProperty consumer(@Nullable Object clientValue) {
        return new ClientDslProperty(clientValue);
    }

    @NotNull
    public final ClientDslProperty stub(@Nullable Object clientValue) {
        return new ClientDslProperty(clientValue);
    }

    @NotNull
    public final ServerDslProperty server(@Nullable Object serverValue) {
        return new ServerDslProperty(serverValue);
    }

    @NotNull
    public final ServerDslProperty p(@Nullable Object serverValue) {
        return new ServerDslProperty(serverValue);
    }

    @NotNull
    public final ServerDslProperty producer(@Nullable Object serverValue) {
        return new ServerDslProperty(serverValue);
    }

    @NotNull
    public final ServerDslProperty test(@Nullable Object serverValue) {
        return new ServerDslProperty(serverValue);
    }

    @NotNull
    public final OptionalProperty optional(@Nullable Object value) {
        return new OptionalProperty(value);
    }

    @NotNull
    public final ExecutionProperty execute(@NotNull String commandToExecute) {
        Intrinsics.checkNotNullParameter((Object)commandToExecute, (String)"commandToExecute");
        return new ExecutionProperty(commandToExecute);
    }

    @NotNull
    public final FromFileProperty file(@NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        Charset charset = Charset.defaultCharset();
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"defaultCharset(...)");
        return this.file(relativePath, charset);
    }

    @NotNull
    public final FromFileProperty file(@NotNull String relativePath, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        return new FromFileProperty(this.fileLocation(relativePath), String.class, charset);
    }

    @NotNull
    public final FromFileProperty fileAsBytes(@NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        return new FromFileProperty(this.fileLocation(relativePath), byte[].class);
    }

    @NotNull
    public final Body bodyFromFile(@NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        Charset charset = Charset.defaultCharset();
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"defaultCharset(...)");
        return this.bodyFromFile(relativePath, charset);
    }

    @NotNull
    public final Body bodyFromFile(@NotNull String relativePath, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        return new Body((Serializable)new FromFileProperty(this.fileLocation(relativePath), String.class, charset));
    }

    @NotNull
    public final Body bodyFromFileAsBytes(@NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        return new Body((Serializable)new FromFileProperty(this.fileLocation(relativePath), byte[].class));
    }

    private final File fileLocation(String relativePath) {
        URL uRL = Thread.currentThread().getContextClassLoader().getResource(relativePath);
        if (uRL == null) {
            throw new IllegalStateException("File [" + relativePath + "] is not present");
        }
        URL resource = uRL;
        try {
            return new File(resource.toURI());
        }
        catch (URISyntaxException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @NotNull
    public final NamedProperty named(@NotNull DslProperty<Object> name, @NotNull DslProperty<Object> value) {
        Intrinsics.checkNotNullParameter(name, (String)"name");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        return new NamedProperty(name, value);
    }

    @NotNull
    public final NamedProperty named(@NotNull DslProperty<Object> name, @NotNull DslProperty<Object> value, @NotNull DslProperty<Object> contentType) {
        Intrinsics.checkNotNullParameter(name, (String)"name");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        Intrinsics.checkNotNullParameter(contentType, (String)"contentType");
        return new NamedProperty(name, value, contentType);
    }

    @NotNull
    public final NamedProperty named(@NotNull Map<String, ? extends DslProperty<Object>> namedMap) {
        Intrinsics.checkNotNullParameter(namedMap, (String)"namedMap");
        return new NamedProperty(namedMap);
    }

    @NotNull
    public final RegexProperty regexProperty(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return new RegexProperty(value);
    }

    @NotNull
    public final RegexProperty regex(@NotNull String regex) {
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        Pattern pattern = Pattern.compile(regex);
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        return this.regexProperty(pattern);
    }

    @NotNull
    public final RegexProperty regex(@NotNull Pattern regex) {
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        return this.regexProperty(regex);
    }

    @NotNull
    public final RegexProperty regex(@NotNull RegexProperty regex) {
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        return regex;
    }
}

