/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.spec.internal;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.cloud.contract.spec.internal.BodyMatchers;
import org.springframework.cloud.contract.spec.internal.MatchingType;
import org.springframework.cloud.contract.spec.internal.MatchingTypeValue;
import org.springframework.cloud.contract.spec.internal.MatchingTypeValueHolder;
import org.springframework.cloud.contract.spec.internal.RegexMatchingTypeValue;
import org.springframework.cloud.contract.spec.internal.RegexPatterns;
import org.springframework.cloud.contract.spec.internal.RegexProperty;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0007J\u0016\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0007J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0006J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001cJ\u001f\u0010\u001d\u001a\u00020\u00072\u0017\u0010\u001e\u001a\u0013\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u000b0\u001f\u00a2\u0006\u0002\b!J\r\u0010\"\u001a\u00020#H\u0010\u00a2\u0006\u0002\b$J!\u0010%\u001a\u0002H&\"\b\b\u0000\u0010&*\u00020#2\u0006\u0010'\u001a\u0002H&H\u0000\u00a2\u0006\u0004\b(\u0010)R*\u0010\u0004\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R\u0011\u0010\u0014\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0011R\u0011\u0010\u0016\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0011\u00a8\u0006*"}, d2={"Lorg/springframework/cloud/contract/spec/internal/BodyMatchersDsl;", "", "<init>", "()V", "jsonPathMatchers", "Ljava/util/LinkedHashMap;", "", "Lorg/springframework/cloud/contract/spec/internal/MatchingTypeValue;", "Lkotlin/collections/LinkedHashMap;", "xPathMatchers", "jsonPath", "", "path", "matcher", "xPath", "byDate", "getByDate", "()Lorg/springframework/cloud/contract/spec/internal/MatchingTypeValue;", "byTime", "getByTime", "byTimestamp", "getByTimestamp", "byEquality", "getByEquality", "byRegex", "Lorg/springframework/cloud/contract/spec/internal/RegexMatchingTypeValue;", "regex", "Lorg/springframework/cloud/contract/spec/internal/RegexProperty;", "Ljava/util/regex/Pattern;", "byType", "configurer", "Lkotlin/Function1;", "Lorg/springframework/cloud/contract/spec/internal/MatchingTypeValueHolder;", "Lkotlin/ExtensionFunctionType;", "get", "Lorg/springframework/cloud/contract/spec/internal/BodyMatchers;", "get$spring_cloud_contract_spec_kotlin", "configureBodyMatchers", "T", "bodyMatchers", "configureBodyMatchers$spring_cloud_contract_spec_kotlin", "(Lorg/springframework/cloud/contract/spec/internal/BodyMatchers;)Lorg/springframework/cloud/contract/spec/internal/BodyMatchers;", "spring-cloud-contract-spec-kotlin"})
public class BodyMatchersDsl {
    @NotNull
    private final LinkedHashMap<String, MatchingTypeValue> jsonPathMatchers = new LinkedHashMap();
    @NotNull
    private final LinkedHashMap<String, MatchingTypeValue> xPathMatchers = new LinkedHashMap();

    public final void jsonPath(@NotNull String path, @NotNull MatchingTypeValue matcher) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        ((Map)this.jsonPathMatchers).put(path, matcher);
    }

    public final void xPath(@NotNull String path, @NotNull MatchingTypeValue matcher) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        ((Map)this.xPathMatchers).put(path, matcher);
    }

    @NotNull
    public final MatchingTypeValue getByDate() {
        return new MatchingTypeValue(MatchingType.DATE, (Object)RegexPatterns.isoDate());
    }

    @NotNull
    public final MatchingTypeValue getByTime() {
        return new MatchingTypeValue(MatchingType.TIME, (Object)RegexPatterns.isoTime());
    }

    @NotNull
    public final MatchingTypeValue getByTimestamp() {
        return new MatchingTypeValue(MatchingType.TIMESTAMP, (Object)RegexPatterns.isoDateTime());
    }

    @NotNull
    public final MatchingTypeValue getByEquality() {
        return new MatchingTypeValue(MatchingType.EQUALITY);
    }

    @NotNull
    public final RegexMatchingTypeValue byRegex(@NotNull String regex) {
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        Pattern pattern = Pattern.compile(regex);
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        return this.byRegex(pattern);
    }

    @NotNull
    public final RegexMatchingTypeValue byRegex(@NotNull RegexProperty regex) {
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        return new RegexMatchingTypeValue(MatchingType.REGEX, (Object)regex);
    }

    @NotNull
    public final RegexMatchingTypeValue byRegex(@NotNull Pattern regex) {
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        return new RegexMatchingTypeValue(MatchingType.REGEX, (Object)new RegexProperty((Object)regex));
    }

    @NotNull
    public final MatchingTypeValue byType(@NotNull Function1<? super MatchingTypeValueHolder, Unit> configurer) {
        Intrinsics.checkNotNullParameter(configurer, (String)"configurer");
        MatchingTypeValueHolder matchingTypeValueHolder = new MatchingTypeValueHolder();
        configurer.invoke((Object)matchingTypeValueHolder);
        MatchingTypeValue matchingTypeValue = matchingTypeValueHolder.matchingTypeValue;
        Intrinsics.checkNotNullExpressionValue((Object)matchingTypeValue, (String)"matchingTypeValue");
        return matchingTypeValue;
    }

    @NotNull
    public BodyMatchers get$spring_cloud_contract_spec_kotlin() {
        return this.configureBodyMatchers$spring_cloud_contract_spec_kotlin(new BodyMatchers());
    }

    @NotNull
    public final <T extends BodyMatchers> T configureBodyMatchers$spring_cloud_contract_spec_kotlin(@NotNull T bodyMatchers) {
        Intrinsics.checkNotNullParameter(bodyMatchers, (String)"bodyMatchers");
        this.jsonPathMatchers.forEach((arg_0, arg_1) -> BodyMatchersDsl.configureBodyMatchers$lambda$0((Function2)new Function2<String, MatchingTypeValue, Unit>(bodyMatchers){

            public final void invoke(String p0, MatchingTypeValue p1) {
                ((BodyMatchers)this.receiver).jsonPath(p0, p1);
            }
        }, arg_0, arg_1));
        this.xPathMatchers.forEach((arg_0, arg_1) -> BodyMatchersDsl.configureBodyMatchers$lambda$1((Function2)new Function2<String, MatchingTypeValue, Unit>(bodyMatchers){

            public final void invoke(String p0, MatchingTypeValue p1) {
                ((BodyMatchers)this.receiver).xPath(p0, p1);
            }
        }, arg_0, arg_1));
        return bodyMatchers;
    }

    private static final void configureBodyMatchers$lambda$0(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final void configureBodyMatchers$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }
}

