/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.spec.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.springframework.cloud.contract.spec.internal.DslProperty;
import org.springframework.cloud.contract.spec.internal.MatchingStrategy;
import org.springframework.cloud.contract.spec.internal.RegexProperty;

public final class ValidateUtils {
    public static List<MatchingStrategy.Type> ALLOWED_MATCHING_TYPES_ON_SERVER_SIDE = new ArrayList<MatchingStrategy.Type>(Arrays.asList(MatchingStrategy.Type.EQUAL_TO, MatchingStrategy.Type.ABSENT));

    private ValidateUtils() {
        throw new IllegalStateException("Can't instantiate an utility class");
    }

    public static Object validateServerValueIsAvailable(Object value, String msg) {
        if (value instanceof Pattern) {
            ValidateUtils.validateServerValue((Pattern)value, msg);
        } else if (value instanceof RegexProperty) {
            RegexProperty property = (RegexProperty)value;
            ValidateUtils.validateServerValue(property.getPattern(), msg);
        } else if (value instanceof MatchingStrategy) {
            ValidateUtils.validateServerValue((MatchingStrategy)value, msg);
        } else if (value instanceof DslProperty) {
            ValidateUtils.validateServerValue((DslProperty)value, msg);
        } else {
            ValidateUtils.validateServerValue(value, msg);
        }
        return value;
    }

    public static void validateServerValue(Pattern pattern, String msg) {
        throw new IllegalStateException(msg + " can't be a pattern for the server side");
    }

    public static void validateServerValue(MatchingStrategy matchingStrategy, String msg) {
        if (!ALLOWED_MATCHING_TYPES_ON_SERVER_SIDE.contains((Object)matchingStrategy.getType())) {
            throw new IllegalStateException(msg + " can't be of a matching type: " + String.valueOf((Object)matchingStrategy.getType()) + " for the server side");
        }
        ValidateUtils.validateServerValue(matchingStrategy.getServerValue(), msg);
    }

    public static void validateServerValue(DslProperty value, String msg) {
        ValidateUtils.validateServerValue(value.getServerValue(), msg);
    }

    public static void validateServerValue(Object value, String msg) {
    }
}

