/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.spec.internal;

import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.contract.spec.internal.Body;
import org.springframework.cloud.contract.spec.internal.BodyMatchers;
import org.springframework.cloud.contract.spec.internal.ClientDslProperty;
import org.springframework.cloud.contract.spec.internal.Common;
import org.springframework.cloud.contract.spec.internal.Cookies;
import org.springframework.cloud.contract.spec.internal.DslProperty;
import org.springframework.cloud.contract.spec.internal.Headers;
import org.springframework.cloud.contract.spec.internal.HttpMethods;
import org.springframework.cloud.contract.spec.internal.MatchingStrategy;
import org.springframework.cloud.contract.spec.internal.Multipart;
import org.springframework.cloud.contract.spec.internal.OptionalProperty;
import org.springframework.cloud.contract.spec.internal.PatternValueDslProperty;
import org.springframework.cloud.contract.spec.internal.RegexCreatingProperty;
import org.springframework.cloud.contract.spec.internal.RegexProperty;
import org.springframework.cloud.contract.spec.internal.ServerDslProperty;
import org.springframework.cloud.contract.spec.internal.Url;
import org.springframework.cloud.contract.spec.internal.UrlPath;
import org.springframework.cloud.contract.spec.util.RegexpUtils;

public class Request
extends Common
implements RegexCreatingProperty<ClientDslProperty> {
    private static final Log log = LogFactory.getLog(Request.class);
    private ClientPatternValueDslProperty property = new ClientPatternValueDslProperty();
    private DslProperty method;
    private Url url;
    private UrlPath urlPath;
    private Headers headers;
    private Cookies cookies;
    private Body body;
    private Multipart multipart;
    private BodyMatchers bodyMatchers;

    public Request() {
    }

    public Request(Request request) {
        this.method = request.getMethod();
        this.url = request.getUrl();
        this.urlPath = request.getUrlPath();
        this.headers = request.getHeaders();
        this.cookies = request.getCookies();
        this.body = request.getBody();
        this.multipart = request.getMultipart();
    }

    public void method(String method) {
        this.method = this.toDslProperty(method);
    }

    public void method(DslProperty method) {
        this.method = this.toDslProperty(method);
    }

    public void url(Object url) {
        this.url = new Url(url);
    }

    public void url(DslProperty url) {
        this.url = new Url(url);
    }

    public void urlPath(String path) {
        this.urlPath = new UrlPath(path);
    }

    public void urlPath(Object path) {
        this.urlPath = new UrlPath(path);
    }

    public void urlPath(DslProperty path) {
        this.urlPath = new UrlPath(path);
    }

    public void body(Map<String, Object> body) {
        this.body = new Body(this.convertObjectsToDslProperties(body));
    }

    public void body(List body) {
        this.body = new Body(this.convertObjectsToDslProperties(body));
    }

    public void body(MatchingStrategy matchingStrategy) {
        this.body = new Body(matchingStrategy);
    }

    public void body(DslProperty dslProperty) {
        this.body = new Body(dslProperty);
    }

    public void body(Object bodyAsValue) {
        this.body = new Body(bodyAsValue);
    }

    public Body getBody() {
        return this.body;
    }

    public void setBody(Body body) {
        this.body = body;
    }

    public void multipart(Map<String, Object> body) {
        this.multipart = new Multipart(this.convertObjectsToDslProperties(body));
    }

    public void multipart(List multipartAsList) {
        this.multipart = Multipart.build(this.convertObjectsToDslProperties(multipartAsList));
    }

    public void multipart(DslProperty dslProperty) {
        this.multipart = new Multipart(dslProperty);
    }

    public void multipart(Object multipartAsValue) {
        this.multipart = Multipart.build(multipartAsValue);
    }

    public MatchingStrategy equalTo(Object value) {
        return new MatchingStrategy(value, MatchingStrategy.Type.EQUAL_TO);
    }

    public MatchingStrategy containing(Object value) {
        return new MatchingStrategy(value, MatchingStrategy.Type.CONTAINS);
    }

    public MatchingStrategy matching(Object value) {
        return new MatchingStrategy(value, MatchingStrategy.Type.MATCHING);
    }

    public MatchingStrategy notMatching(Object value) {
        return new MatchingStrategy(value, MatchingStrategy.Type.NOT_MATCHING);
    }

    public MatchingStrategy equalToXml(Object value) {
        return new MatchingStrategy(value, MatchingStrategy.Type.EQUAL_TO_XML);
    }

    public MatchingStrategy equalToJson(Object value) {
        return new MatchingStrategy(value, MatchingStrategy.Type.EQUAL_TO_JSON);
    }

    public MatchingStrategy absent() {
        return new MatchingStrategy((Object)true, MatchingStrategy.Type.ABSENT);
    }

    @Override
    public void assertThatSidesMatch(Object stubSide, Object testSide) {
        if (testSide instanceof OptionalProperty) {
            throw new IllegalStateException("Optional can be used only for the stub side of the request!");
        }
        super.assertThatSidesMatch(stubSide, testSide);
    }

    public DslProperty value(ClientDslProperty client) {
        Object concreteValue = client.getServerValue();
        Object dynamicValue = client.getClientValue();
        if (dynamicValue instanceof RegexProperty && client.isSingleValue()) {
            return ((RegexProperty)dynamicValue).dynamicClientEscapedConcreteProducer();
        }
        if (concreteValue instanceof RegexProperty && !client.isSingleValue()) {
            concreteValue = dynamicValue;
        }
        return new DslProperty(dynamicValue, concreteValue);
    }

    public DslProperty $(RegexProperty property) {
        return this.value(property);
    }

    public DslProperty value(RegexProperty property) {
        return this.value(this.client(property));
    }

    public DslProperty $(ClientDslProperty client) {
        return this.value(client);
    }

    public DslProperty value(Pattern client) {
        return this.value(new RegexProperty(client));
    }

    public DslProperty $(Pattern client) {
        return this.value(client);
    }

    @Override
    public RegexProperty regexProperty(Object object) {
        return new RegexProperty(object).dynamicClientConcreteProducer();
    }

    @Override
    public DslProperty value(ClientDslProperty client, ServerDslProperty server) {
        if (server.getClientValue() instanceof RegexProperty) {
            throw new IllegalStateException("You can't have a regular expression for the request on the server side");
        }
        return super.value(client, server);
    }

    @Override
    public DslProperty value(ServerDslProperty server, ClientDslProperty client) {
        if (server.getClientValue() instanceof RegexProperty) {
            throw new IllegalStateException("You can't have a regular expression for the request on the server side");
        }
        return super.value(server, client);
    }

    public ClientPatternValueDslProperty getProperty() {
        return this.property;
    }

    public void setProperty(ClientPatternValueDslProperty property) {
        this.property = property;
    }

    public DslProperty getMethod() {
        return this.method;
    }

    public void setMethod(DslProperty method) {
        this.method = method;
    }

    public Url getUrl() {
        return this.url;
    }

    public void setUrl(Url url) {
        this.url = url;
    }

    public UrlPath getUrlPath() {
        return this.urlPath;
    }

    public void setUrlPath(UrlPath urlPath) {
        this.urlPath = urlPath;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public void setHeaders(Headers headers) {
        this.headers = headers;
    }

    public Cookies getCookies() {
        return this.cookies;
    }

    public void setCookies(Cookies cookies) {
        this.cookies = cookies;
    }

    public Multipart getMultipart() {
        return this.multipart;
    }

    public void setMultipart(Multipart multipart) {
        this.multipart = multipart;
    }

    public BodyMatchers getBodyMatchers() {
        return this.bodyMatchers;
    }

    public void setBodyMatchers(BodyMatchers bodyMatchers) {
        this.bodyMatchers = bodyMatchers;
    }

    @Override
    public ClientDslProperty anyAlphaUnicode() {
        return (ClientDslProperty)this.property.anyAlphaUnicode();
    }

    @Override
    public ClientDslProperty anyAlphaNumeric() {
        return (ClientDslProperty)this.property.anyAlphaNumeric();
    }

    @Override
    public ClientDslProperty anyNumber() {
        return (ClientDslProperty)this.property.anyNumber();
    }

    @Override
    public ClientDslProperty anyInteger() {
        return (ClientDslProperty)this.property.anyInteger();
    }

    @Override
    public ClientDslProperty anyPositiveInt() {
        return (ClientDslProperty)this.property.anyPositiveInt();
    }

    @Override
    public ClientDslProperty anyDouble() {
        return (ClientDslProperty)this.property.anyDouble();
    }

    @Override
    public ClientDslProperty anyHex() {
        return (ClientDslProperty)this.property.anyHex();
    }

    @Override
    public ClientDslProperty aBoolean() {
        return (ClientDslProperty)this.property.aBoolean();
    }

    @Override
    public ClientDslProperty anyIpAddress() {
        return (ClientDslProperty)this.property.anyIpAddress();
    }

    @Override
    public ClientDslProperty anyHostname() {
        return (ClientDslProperty)this.property.anyHostname();
    }

    @Override
    public ClientDslProperty anyEmail() {
        return (ClientDslProperty)this.property.anyEmail();
    }

    @Override
    public ClientDslProperty anyUrl() {
        return (ClientDslProperty)this.property.anyUrl();
    }

    @Override
    public ClientDslProperty anyHttpsUrl() {
        return (ClientDslProperty)this.property.anyHttpsUrl();
    }

    @Override
    public ClientDslProperty anyUuid() {
        return (ClientDslProperty)this.property.anyUuid();
    }

    @Override
    public ClientDslProperty anyDate() {
        return (ClientDslProperty)this.property.anyDate();
    }

    @Override
    public ClientDslProperty anyDateTime() {
        return (ClientDslProperty)this.property.anyDateTime();
    }

    @Override
    public ClientDslProperty anyTime() {
        return (ClientDslProperty)this.property.anyTime();
    }

    @Override
    public ClientDslProperty anyIso8601WithOffset() {
        return (ClientDslProperty)this.property.anyIso8601WithOffset();
    }

    @Override
    public ClientDslProperty anyNonBlankString() {
        return (ClientDslProperty)this.property.anyNonBlankString();
    }

    @Override
    public ClientDslProperty anyNonEmptyString() {
        return (ClientDslProperty)this.property.anyNonEmptyString();
    }

    @Override
    public ClientDslProperty anyOf(String ... values) {
        return (ClientDslProperty)this.property.anyOf(values);
    }

    public String GET() {
        return HttpMethods.GET;
    }

    public String HEAD() {
        return HttpMethods.HEAD;
    }

    public String POST() {
        return HttpMethods.POST;
    }

    public String PUT() {
        return HttpMethods.PUT;
    }

    public String PATCH() {
        return HttpMethods.PATCH;
    }

    public String DELETE() {
        return HttpMethods.DELETE;
    }

    public String OPTIONS() {
        return HttpMethods.OPTIONS;
    }

    public String TRACE() {
        return HttpMethods.TRACE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Request request = (Request)o;
        return Objects.equals(this.method, request.method) && Objects.equals(this.url, request.url) && Objects.equals(this.urlPath, request.urlPath) && Objects.equals(this.headers, request.headers) && Objects.equals(this.cookies, request.cookies) && Objects.equals(this.body, request.body) && Objects.equals(this.multipart, request.multipart) && Objects.equals(this.bodyMatchers, request.bodyMatchers);
    }

    public int hashCode() {
        return Objects.hash(this.method, this.url, this.urlPath, this.headers, this.cookies, this.body, this.multipart, this.bodyMatchers);
    }

    public String toString() {
        return "Request{\nmethod=" + String.valueOf(this.method) + ", \n\turl=" + String.valueOf(this.url) + ", \n\turlPath=" + String.valueOf(this.urlPath) + ", \n\theaders=" + String.valueOf(this.headers) + ", \n\tcookies=" + String.valueOf(this.cookies) + ", \n\tbody=" + String.valueOf(this.body) + ", \n\tmultipart=" + String.valueOf(this.multipart) + ", \n\tbodyMatchers=" + String.valueOf(this.bodyMatchers) + "}";
    }

    public void url(Object url, Consumer<Url> consumer) {
        this.url = new Url(url);
        consumer.accept(this.url);
    }

    public void url(DslProperty url, Consumer<Url> consumer) {
        this.url = new Url(url);
        consumer.accept(this.url);
    }

    public void urlPath(String path, Consumer<UrlPath> consumer) {
        this.urlPath = new UrlPath(path);
        consumer.accept(this.urlPath);
    }

    public void urlPath(DslProperty path, Consumer<UrlPath> consumer) {
        this.urlPath = new UrlPath(path);
        consumer.accept(this.urlPath);
    }

    public void headers(Consumer<Headers> consumer) {
        this.headers = new RequestHeaders();
        consumer.accept(this.headers);
    }

    public void cookies(Consumer<Cookies> consumer) {
        this.cookies = new RequestCookies();
        consumer.accept(this.cookies);
    }

    public void bodyMatchers(Consumer<BodyMatchers> consumer) {
        this.bodyMatchers = new BodyMatchers();
        consumer.accept(this.bodyMatchers);
    }

    public void url(Object url, @DelegatesTo(value=Url.class) Closure consumer) {
        this.url = new Url(url);
        consumer.setDelegate((Object)this.url);
        consumer.call();
    }

    public void url(DslProperty url, @DelegatesTo(value=Url.class) Closure consumer) {
        this.url = new Url(url);
        consumer.setDelegate((Object)this.url);
        consumer.call();
    }

    public void urlPath(String path, @DelegatesTo(value=UrlPath.class) Closure consumer) {
        this.urlPath = new UrlPath(path);
        consumer.setDelegate((Object)this.urlPath);
        consumer.call();
    }

    public void urlPath(DslProperty path, @DelegatesTo(value=UrlPath.class) Closure consumer) {
        this.urlPath = new UrlPath(path);
        consumer.setDelegate((Object)this.urlPath);
        consumer.call();
    }

    public void headers(@DelegatesTo(value=Headers.class) Closure consumer) {
        this.headers = new RequestHeaders();
        consumer.setDelegate((Object)this.headers);
        consumer.call();
    }

    public void cookies(@DelegatesTo(value=Cookies.class) Closure consumer) {
        this.cookies = new RequestCookies();
        consumer.setDelegate((Object)this.cookies);
        consumer.call();
    }

    public void bodyMatchers(@DelegatesTo(value=BodyMatchers.class) Closure consumer) {
        this.bodyMatchers = new BodyMatchers();
        consumer.setDelegate((Object)this.bodyMatchers);
        consumer.call();
    }

    private static final class ClientPatternValueDslProperty
    extends PatternValueDslProperty<ClientDslProperty> {
        private ClientPatternValueDslProperty() {
        }

        @Override
        protected ClientDslProperty createProperty(Pattern pattern, Object generatedValue) {
            return new ClientDslProperty(pattern, generatedValue);
        }
    }

    static class RequestHeaders
    extends Headers {
        private final Common common = new Common();

        RequestHeaders() {
        }

        @Override
        public DslProperty matching(String value) {
            return this.common.$(this.common.c(this.common.regex(RegexpUtils.escapeSpecialRegexWithSingleEscape(value) + ".*")), this.common.p(value));
        }
    }

    static class RequestCookies
    extends Cookies {
        private final Common common = new Common();

        RequestCookies() {
        }

        @Override
        public DslProperty matching(String value) {
            return this.common.$(this.common.c(this.common.regex(RegexpUtils.escapeSpecialRegexWithSingleEscape(value) + ".*")), this.common.p(value));
        }
    }

    private class ClientRequest
    extends Request {
        ClientRequest(Request enclosing, Request request2) {
            super(request2);
        }
    }

    private class ServerRequest
    extends Request {
        ServerRequest(Request enclosing, Request request2) {
            super(request2);
        }
    }
}

