/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.spec.internal;

import java.util.Objects;
import java.util.regex.Pattern;
import org.springframework.cloud.contract.spec.internal.ClientDslProperty;
import org.springframework.cloud.contract.spec.internal.Common;
import org.springframework.cloud.contract.spec.internal.DslProperty;
import org.springframework.cloud.contract.spec.internal.ExecutionProperty;
import org.springframework.cloud.contract.spec.internal.PatternValueDslProperty;
import org.springframework.cloud.contract.spec.internal.RegexCreatingProperty;
import org.springframework.cloud.contract.spec.internal.RegexProperty;

public class Input
extends Common
implements RegexCreatingProperty<ClientDslProperty> {
    private ClientPatternValueDslProperty property = new ClientPatternValueDslProperty();
    private ExecutionProperty triggeredBy;
    private ExecutionProperty assertThat;

    public void triggeredBy(String triggeredBy) {
        this.triggeredBy = new ExecutionProperty(triggeredBy);
    }

    public DslProperty value(ClientDslProperty client) {
        Object dynamicValue = client.getClientValue();
        Object concreteValue = client.getServerValue();
        if (dynamicValue instanceof RegexProperty) {
            return ((RegexProperty)dynamicValue).dynamicClientConcreteProducer();
        }
        return new DslProperty(dynamicValue, concreteValue);
    }

    public DslProperty value(RegexProperty prop) {
        return this.value(this.client(prop));
    }

    public DslProperty $(RegexProperty prop) {
        return this.value(this.client(prop));
    }

    public DslProperty $(ClientDslProperty client) {
        return this.value(client);
    }

    @Override
    public RegexProperty regexProperty(Object object) {
        return new RegexProperty(object).dynamicClientConcreteProducer();
    }

    public void assertThat(String assertThat) {
        this.assertThat = new ExecutionProperty(assertThat);
    }

    public ClientPatternValueDslProperty getProperty() {
        return this.property;
    }

    public void setProperty(ClientPatternValueDslProperty property) {
        this.property = property;
    }

    public ExecutionProperty getTriggeredBy() {
        return this.triggeredBy;
    }

    public void setTriggeredBy(ExecutionProperty triggeredBy) {
        this.triggeredBy = triggeredBy;
    }

    public ExecutionProperty getAssertThat() {
        return this.assertThat;
    }

    public void setAssertThat(ExecutionProperty assertThat) {
        this.assertThat = assertThat;
    }

    @Override
    public ClientDslProperty anyAlphaUnicode() {
        return (ClientDslProperty)this.property.anyAlphaUnicode();
    }

    @Override
    public ClientDslProperty anyAlphaNumeric() {
        return (ClientDslProperty)this.property.anyAlphaNumeric();
    }

    @Override
    public ClientDslProperty anyNumber() {
        return (ClientDslProperty)this.property.anyNumber();
    }

    @Override
    public ClientDslProperty anyInteger() {
        return (ClientDslProperty)this.property.anyInteger();
    }

    @Override
    public ClientDslProperty anyPositiveInt() {
        return (ClientDslProperty)this.property.anyPositiveInt();
    }

    @Override
    public ClientDslProperty anyDouble() {
        return (ClientDslProperty)this.property.anyDouble();
    }

    @Override
    public ClientDslProperty anyHex() {
        return (ClientDslProperty)this.property.anyHex();
    }

    @Override
    public ClientDslProperty aBoolean() {
        return (ClientDslProperty)this.property.aBoolean();
    }

    @Override
    public ClientDslProperty anyIpAddress() {
        return (ClientDslProperty)this.property.anyIpAddress();
    }

    @Override
    public ClientDslProperty anyHostname() {
        return (ClientDslProperty)this.property.anyHostname();
    }

    @Override
    public ClientDslProperty anyEmail() {
        return (ClientDslProperty)this.property.anyEmail();
    }

    @Override
    public ClientDslProperty anyUrl() {
        return (ClientDslProperty)this.property.anyUrl();
    }

    @Override
    public ClientDslProperty anyHttpsUrl() {
        return (ClientDslProperty)this.property.anyHttpsUrl();
    }

    @Override
    public ClientDslProperty anyUuid() {
        return (ClientDslProperty)this.property.anyUuid();
    }

    @Override
    public ClientDslProperty anyDate() {
        return (ClientDslProperty)this.property.anyDate();
    }

    @Override
    public ClientDslProperty anyDateTime() {
        return (ClientDslProperty)this.property.anyDateTime();
    }

    @Override
    public ClientDslProperty anyTime() {
        return (ClientDslProperty)this.property.anyTime();
    }

    @Override
    public ClientDslProperty anyIso8601WithOffset() {
        return (ClientDslProperty)this.property.anyIso8601WithOffset();
    }

    @Override
    public ClientDslProperty anyNonBlankString() {
        return (ClientDslProperty)this.property.anyNonBlankString();
    }

    @Override
    public ClientDslProperty anyNonEmptyString() {
        return (ClientDslProperty)this.property.anyNonEmptyString();
    }

    @Override
    public ClientDslProperty anyOf(String ... values) {
        return (ClientDslProperty)this.property.anyOf(values);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Input input = (Input)o;
        return Objects.equals(this.triggeredBy, input.triggeredBy) && Objects.equals(this.assertThat, input.assertThat);
    }

    public int hashCode() {
        return Objects.hash(this.triggeredBy, this.assertThat);
    }

    public String toString() {
        return "Input{\n\t, \n\ttriggeredBy=" + String.valueOf(this.triggeredBy) + ", \n\tassertThat=" + String.valueOf(this.assertThat) + "} \n\t" + super.toString();
    }

    private static final class ClientPatternValueDslProperty
    extends PatternValueDslProperty<ClientDslProperty> {
        private ClientPatternValueDslProperty() {
        }

        @Override
        protected ClientDslProperty createProperty(Pattern pattern, Object generatedValue) {
            return new ClientDslProperty(pattern, generatedValue);
        }
    }
}

