/*
 * Decompiled with CFR 0.152.
 */
package com.example;

import com.example.BookReturned;
import com.example.BookService;
import org.apache.camel.CamelContext;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.rabbitmq.RabbitMQComponent;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.dataformat.JsonLibrary;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
public class BookRouteConfiguration {
    @Bean
    RoutesBuilder myRouter(final BookService bookService, final CamelContext context, final @Value(value="${spring.rabbitmq.port}") int port) {
        return new RouteBuilder(){

            public void configure() throws Exception {
                RabbitMQComponent component = (RabbitMQComponent)context.getComponent("rabbitmq", RabbitMQComponent.class);
                component.setAddresses("localhost:" + port);
                ((RouteDefinition)this.from("direct:start").unmarshal().json(JsonLibrary.Jackson, BookReturned.class).bean((Object)bookService)).marshal().json(JsonLibrary.Jackson, BookReturned.class).to("rabbitmq:output?queue=output");
            }
        };
    }
}

