/*
 * Decompiled with CFR 0.152.
 */
package com.example;

import com.example.Book;
import com.example.BookService;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class BookServiceImpl
implements BookService {
    public static final Logger LOG = LoggerFactory.getLogger(BookServiceImpl.class);
    private List<Book> books = new LinkedList<Book>();
    private RabbitTemplate rabbitTemplate;

    @Autowired
    BookServiceImpl(RabbitTemplate rabbitTemplate) {
        this.rabbitTemplate = rabbitTemplate;
    }

    @Override
    public void sendBook(Book book, String replyTo) {
        LOG.info("Received new book with bookname = " + book.getName());
        this.newBook(book);
        this.rabbitTemplate.convertAndSend("", replyTo, (Object)book);
    }

    @Override
    public void newBook(Book book) {
        this.books.add(book);
    }

    @Override
    public Book getBook(int index) {
        return this.books.get(index);
    }

    @Override
    public int noOfBooks() {
        return this.books.size();
    }

    @Override
    public List<Book> getBooks() {
        return this.books;
    }
}

