/*
 * Decompiled with CFR 0.152.
 */
package com.example;

import com.example.MessagePublisher;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.core.TopicExchange;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.support.converter.ContentTypeDelegatingMessageConverter;
import org.springframework.amqp.support.converter.Jackson2JsonMessageConverter;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;

@SpringBootApplication
public class AmqpMessagingApplication {
    public static void main(String[] args) {
        SpringApplication.run(AmqpMessagingApplication.class, (String[])args);
    }

    @Bean
    public MessageConverter messageConverter() {
        Jackson2JsonMessageConverter jsonMessageConverter = new Jackson2JsonMessageConverter(new ObjectMapper());
        jsonMessageConverter.setCreateMessageIds(true);
        ContentTypeDelegatingMessageConverter messageConverter = new ContentTypeDelegatingMessageConverter((MessageConverter)jsonMessageConverter);
        messageConverter.addDelegate("application/json", (MessageConverter)jsonMessageConverter);
        return messageConverter;
    }

    @Bean
    public RabbitTemplate rabbitTemplate(ConnectionFactory connectionFactory, MessageConverter messageConverter) {
        RabbitTemplate rabbitTemplate = new RabbitTemplate(connectionFactory);
        rabbitTemplate.setMessageConverter(messageConverter);
        return rabbitTemplate;
    }

    @Bean
    public Exchange testExchange() {
        return new TopicExchange("test-exchange");
    }

    @Bean
    MessagePublisher messagePublisher(RabbitTemplate rabbitTemplate) {
        return new MessagePublisher(rabbitTemplate, this.testExchange());
    }
}

