/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.spec.pact;

import au.com.dius.pact.model.generators.Category;
import au.com.dius.pact.model.generators.DateGenerator;
import au.com.dius.pact.model.generators.DateTimeGenerator;
import au.com.dius.pact.model.generators.Generator;
import au.com.dius.pact.model.generators.Generators;
import au.com.dius.pact.model.generators.RandomBooleanGenerator;
import au.com.dius.pact.model.generators.RandomDecimalGenerator;
import au.com.dius.pact.model.generators.RandomHexadecimalGenerator;
import au.com.dius.pact.model.generators.RandomIntGenerator;
import au.com.dius.pact.model.generators.RandomStringGenerator;
import au.com.dius.pact.model.generators.RegexGenerator;
import au.com.dius.pact.model.generators.TimeGenerator;
import au.com.dius.pact.model.generators.UuidGenerator;
import groovy.lang.Closure;
import groovy.lang.GString;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.springframework.cloud.contract.spec.internal.Body;
import org.springframework.cloud.contract.spec.internal.DslProperty;
import org.springframework.cloud.contract.spec.internal.OutputMessage;
import org.springframework.cloud.contract.spec.internal.RegexProperty;
import org.springframework.cloud.contract.verifier.util.ContentUtils;

class ValueGeneratorConverter
implements GroovyObject {
    private static final Pattern INTEGER;
    private static final String INTEGER_PATTERN = "-?(\\d+)";
    private static final Pattern DECIMAL;
    private static final String DECIMAL_PATTERN = "-?(\\d*\\.\\d+)";
    private static final Pattern HEX;
    private static final String HEX_PATTERN = "[a-fA-F0-9]+";
    private static final Pattern ALPHA_NUMERIC;
    private static final String ALPHA_NUMERIC_PATTERN = "[a-zA-Z0-9]+";
    private static final Pattern UUID;
    private static final String UUID_PATTERN = "[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}";
    private static final Pattern ANY_DATE;
    private static final String ANY_DATE_PATTERN = "(\\d\\d\\d\\d)-(0[1-9]|1[012])-(0[1-9]|[12][0-9]|3[01])";
    private static final Pattern ANY_TIME;
    private static final String ANY_TIME_PATTERN = "(2[0-3]|[01][0-9]):([0-5][0-9]):([0-5][0-9])";
    private static final Pattern ANY_DATE_TIME;
    private static final String ANY_DATE_TIME_PATTERN = "([0-9]{4})-(1[0-2]|0[1-9])-(3[01]|0[1-9]|[12][0-9])T(2[0-3]|[01][0-9]):([0-5][0-9]):([0-5][0-9])";
    private static final Pattern TRUE_OR_FALSE;
    private static final String TRUE_OR_FALSE_PATTERN = "(true|false)";
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    @Generated
    public ValueGeneratorConverter() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static DslProperty convert(Generator generator, Closure<DslProperty> dslPropertyProvider) {
        Pattern pattern = null;
        if (generator instanceof RandomIntGenerator) {
            Pattern pattern2;
            pattern = pattern2 = INTEGER;
        } else if (generator instanceof RandomDecimalGenerator) {
            Pattern pattern3;
            pattern = pattern3 = DECIMAL;
        } else if (generator instanceof RandomHexadecimalGenerator) {
            Pattern pattern4;
            pattern = pattern4 = HEX;
        } else if (generator instanceof RandomStringGenerator) {
            Pattern pattern5;
            pattern = pattern5 = ALPHA_NUMERIC;
        } else if (generator instanceof RegexGenerator) {
            Pattern pattern6;
            pattern = pattern6 = Pattern.compile(((RegexGenerator)ScriptBytecodeAdapter.castToType((Object)generator, RegexGenerator.class)).getRegex());
        } else if (generator instanceof UuidGenerator) {
            Pattern pattern7;
            pattern = pattern7 = UUID;
        } else if (generator instanceof DateGenerator) {
            Pattern pattern8;
            pattern = pattern8 = ValueGeneratorConverter.getDateTimePattern(((DateGenerator)ScriptBytecodeAdapter.castToType((Object)generator, DateGenerator.class)).getFormat(), ANY_DATE);
        } else if (generator instanceof TimeGenerator) {
            Pattern pattern9;
            pattern = pattern9 = ValueGeneratorConverter.getDateTimePattern(((TimeGenerator)ScriptBytecodeAdapter.castToType((Object)generator, TimeGenerator.class)).getFormat(), ANY_TIME);
        } else if (generator instanceof DateTimeGenerator) {
            Pattern pattern10;
            pattern = pattern10 = ValueGeneratorConverter.getDateTimePattern(((DateTimeGenerator)ScriptBytecodeAdapter.castToType((Object)generator, DateTimeGenerator.class)).getFormat(), ANY_DATE_TIME);
        } else if (generator instanceof RandomBooleanGenerator) {
            Pattern pattern11;
            pattern = pattern11 = TRUE_OR_FALSE;
        }
        if (pattern == null) {
            throw (Throwable)new UnsupportedOperationException(StringGroovyMethods.plus((String)"We currently don't support a generator of type ", (CharSequence)generator.getClass().getSimpleName()));
        }
        Object generatedValue = generator.generate(ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
        return (DslProperty)ScriptBytecodeAdapter.castToType((Object)dslPropertyProvider.call(new Object[]{pattern, generatedValue}), DslProperty.class);
    }

    private static Pattern getDateTimePattern(String format, Pattern defaultPattern) {
        return DefaultTypeTransformation.booleanUnbox((Object)format) ? Pattern.compile(format) : defaultPattern;
    }

    public static Generators extract(Body body, Closure dslPropertyValueProvider) {
        Generators generators = new Generators();
        ValueGeneratorConverter.traverse(body, dslPropertyValueProvider, "", generators, Category.BODY);
        return generators;
    }

    public static Generators extract(OutputMessage message, Closure dslPropertyValueProvider) {
        Generators generators = new Generators();
        ValueGeneratorConverter.traverse(message.getBody(), dslPropertyValueProvider, "", generators, Category.BODY);
        return generators;
    }

    /*
     * WARNING - void declaration
     */
    private static void traverse(Object value, Closure dslPropertyValueProvider, String path, Generators generators, Category category) {
        block21: {
            Object v;
            Reference category2;
            Reference generators2;
            Reference path2;
            block23: {
                Reference dslPropertyValueProvider2;
                block22: {
                    block20: {
                        void var3_3;
                        void var2_2;
                        dslPropertyValueProvider2 = new Reference((Object)dslPropertyValueProvider);
                        path2 = new Reference((Object)var2_2);
                        generators2 = new Reference((Object)var3_3);
                        category2 = new Reference((Object)category);
                        v = value;
                        if (v instanceof DslProperty) {
                            Object object;
                            v = object = ((Closure)dslPropertyValueProvider2.get()).call(v);
                        }
                        if (v instanceof GString) {
                            Object object;
                            v = object = ContentUtils.extractValue((GString)((GString)ScriptBytecodeAdapter.castToType((Object)v, GString.class)), (Closure)((Closure)dslPropertyValueProvider2.get()));
                        }
                        if (!(v instanceof Map)) break block20;
                        public final class _traverse_closure1
                        extends Closure
                        implements GeneratedClosure {
                            private /* synthetic */ Reference dslPropertyValueProvider;
                            private /* synthetic */ Reference path;
                            private /* synthetic */ Reference generators;
                            private /* synthetic */ Reference category;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _traverse_closure1(Object _outerInstance, Object _thisObject, Reference dslPropertyValueProvider, Reference path, Reference generators, Reference category) {
                                super(_outerInstance, _thisObject);
                                Reference reference;
                                Reference reference2;
                                Reference reference3;
                                Reference reference4;
                                this.dslPropertyValueProvider = reference4 = dslPropertyValueProvider;
                                this.path = reference3 = path;
                                this.generators = reference2 = generators;
                                this.category = reference = category;
                            }

                            public Object doCall(Map.Entry entry) {
                                ValueGeneratorConverter.traverse(entry.getValue(), (Closure)ScriptBytecodeAdapter.castToType((Object)this.dslPropertyValueProvider.get(), Closure.class), StringGroovyMethods.plus((CharSequence)StringGroovyMethods.plus((String)ShortTypeHandling.castToString((Object)this.path.get()), (CharSequence)"."), entry.getKey()), (Generators)ScriptBytecodeAdapter.castToType((Object)this.generators.get(), Generators.class), (Category)ShortTypeHandling.castToEnum((Object)this.category.get(), Category.class));
                                return null;
                            }

                            public Object call(Map.Entry entry) {
                                return this.doCall(entry);
                            }

                            public Closure getDslPropertyValueProvider() {
                                return (Closure)ScriptBytecodeAdapter.castToType((Object)this.dslPropertyValueProvider.get(), Closure.class);
                            }

                            public String getPath() {
                                return ShortTypeHandling.castToString((Object)this.path.get());
                            }

                            public Generators getGenerators() {
                                return (Generators)ScriptBytecodeAdapter.castToType((Object)this.generators.get(), Generators.class);
                            }

                            public Category getCategory() {
                                return (Category)ShortTypeHandling.castToEnum((Object)this.category.get(), Category.class);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _traverse_closure1.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }
                        }
                        DefaultGroovyMethods.each((Object)v, (Closure)new _traverse_closure1(ValueGeneratorConverter.class, ValueGeneratorConverter.class, dslPropertyValueProvider2, path2, generators2, category2));
                        break block21;
                    }
                    if (!(v instanceof Collection)) break block22;
                    public final class _traverse_closure2
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference dslPropertyValueProvider;
                        private /* synthetic */ Reference path;
                        private /* synthetic */ Reference generators;
                        private /* synthetic */ Reference category;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _traverse_closure2(Object _outerInstance, Object _thisObject, Reference dslPropertyValueProvider, Reference path, Reference generators, Reference category) {
                            super(_outerInstance, _thisObject);
                            Reference reference;
                            Reference reference2;
                            Reference reference3;
                            Reference reference4;
                            this.dslPropertyValueProvider = reference4 = dslPropertyValueProvider;
                            this.path = reference3 = path;
                            this.generators = reference2 = generators;
                            this.category = reference = category;
                        }

                        public Object doCall(Object entry, int index) {
                            ValueGeneratorConverter.traverse(entry, (Closure)ScriptBytecodeAdapter.castToType((Object)this.dslPropertyValueProvider.get(), Closure.class), StringGroovyMethods.plus((String)StringGroovyMethods.plus((CharSequence)StringGroovyMethods.plus((String)ShortTypeHandling.castToString((Object)this.path.get()), (CharSequence)"["), (Object)index), (CharSequence)"]"), (Generators)ScriptBytecodeAdapter.castToType((Object)this.generators.get(), Generators.class), (Category)ShortTypeHandling.castToEnum((Object)this.category.get(), Category.class));
                            return null;
                        }

                        public Object call(Object entry, int index) {
                            return this.doCall(entry, index);
                        }

                        public Closure getDslPropertyValueProvider() {
                            return (Closure)ScriptBytecodeAdapter.castToType((Object)this.dslPropertyValueProvider.get(), Closure.class);
                        }

                        public String getPath() {
                            return ShortTypeHandling.castToString((Object)this.path.get());
                        }

                        public Generators getGenerators() {
                            return (Generators)ScriptBytecodeAdapter.castToType((Object)this.generators.get(), Generators.class);
                        }

                        public Category getCategory() {
                            return (Category)ShortTypeHandling.castToEnum((Object)this.category.get(), Category.class);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _traverse_closure2.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }
                    }
                    DefaultGroovyMethods.eachWithIndex((Object)v, (Closure)new _traverse_closure2(ValueGeneratorConverter.class, ValueGeneratorConverter.class, dslPropertyValueProvider2, path2, generators2, category2));
                    break block21;
                }
                if (!(v instanceof DslProperty)) break block23;
                ValueGeneratorConverter.traverse(v, (Closure)dslPropertyValueProvider2.get(), (String)path2.get(), (Generators)generators2.get(), (Category)category2.get());
                break block21;
            }
            if (!(v instanceof RegexProperty || v instanceof Pattern)) break block21;
            RegexProperty regexProperty = new RegexProperty(v);
            String string = regexProperty.pattern();
            if (ScriptBytecodeAdapter.isCase((Object)string, (Object)INTEGER_PATTERN)) {
                ((Generators)generators2.get()).addGenerator((Category)category2.get(), (String)path2.get(), (Generator)new RandomIntGenerator(0, Integer.MAX_VALUE));
            } else if (ScriptBytecodeAdapter.isCase((Object)string, (Object)DECIMAL_PATTERN)) {
                ((Generators)generators2.get()).addGenerator((Category)category2.get(), (String)path2.get(), (Generator)new RandomDecimalGenerator(10));
            } else if (ScriptBytecodeAdapter.isCase((Object)string, (Object)HEX_PATTERN)) {
                ((Generators)generators2.get()).addGenerator((Category)category2.get(), (String)path2.get(), (Generator)new RandomHexadecimalGenerator(10));
            } else if (ScriptBytecodeAdapter.isCase((Object)string, (Object)ALPHA_NUMERIC_PATTERN)) {
                ((Generators)generators2.get()).addGenerator((Category)category2.get(), (String)path2.get(), (Generator)new RandomStringGenerator(10));
            } else if (ScriptBytecodeAdapter.isCase((Object)string, (Object)UUID_PATTERN)) {
                ((Generators)generators2.get()).addGenerator((Category)category2.get(), (String)path2.get(), (Generator)UuidGenerator.INSTANCE);
            } else if (ScriptBytecodeAdapter.isCase((Object)string, (Object)ANY_DATE_PATTERN)) {
                ((Generators)generators2.get()).addGenerator((Category)category2.get(), (String)path2.get(), (Generator)new DateGenerator());
            } else if (ScriptBytecodeAdapter.isCase((Object)string, (Object)ANY_TIME_PATTERN)) {
                ((Generators)generators2.get()).addGenerator((Category)category2.get(), (String)path2.get(), (Generator)new TimeGenerator());
            } else if (ScriptBytecodeAdapter.isCase((Object)string, (Object)ANY_DATE_TIME_PATTERN)) {
                ((Generators)generators2.get()).addGenerator((Category)category2.get(), (String)path2.get(), (Generator)new DateTimeGenerator());
            } else if (ScriptBytecodeAdapter.isCase((Object)string, (Object)TRUE_OR_FALSE_PATTERN)) {
                ((Generators)generators2.get()).addGenerator((Category)category2.get(), (String)path2.get(), (Generator)RandomBooleanGenerator.INSTANCE);
            } else {
                ((Generators)generators2.get()).addGenerator((Category)category2.get(), (String)path2.get(), (Generator)new RegexGenerator(regexProperty.pattern()));
            }
        }
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ValueGeneratorConverter.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Pattern pattern;
        Pattern pattern2;
        Pattern pattern3;
        Pattern pattern4;
        Pattern pattern5;
        Pattern pattern6;
        Pattern pattern7;
        Pattern pattern8;
        Pattern pattern9;
        INTEGER = pattern9 = Pattern.compile(INTEGER_PATTERN);
        DECIMAL = pattern8 = Pattern.compile(DECIMAL_PATTERN);
        HEX = pattern7 = Pattern.compile(HEX_PATTERN);
        ALPHA_NUMERIC = pattern6 = Pattern.compile(ALPHA_NUMERIC_PATTERN);
        UUID = pattern5 = Pattern.compile(UUID_PATTERN);
        ANY_DATE = pattern4 = Pattern.compile(ANY_DATE_PATTERN);
        ANY_TIME = pattern3 = Pattern.compile(ANY_TIME_PATTERN);
        ANY_DATE_TIME = pattern2 = Pattern.compile(ANY_DATE_TIME_PATTERN);
        TRUE_OR_FALSE = pattern = Pattern.compile(TRUE_OR_FALSE_PATTERN);
    }
}

