/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner;

import au.com.dius.pact.model.Pact;
import au.com.dius.pact.model.PactSpecVersion;
import au.com.dius.pact.provider.junit.loader.PactBroker;
import au.com.dius.pact.provider.junit.loader.PactBrokerAuth;
import au.com.dius.pact.provider.junit.loader.PactBrokerLoader;
import au.com.dius.pact.provider.junit.loader.PactLoader;
import au.com.dius.pact.support.expressions.SystemPropertyResolver;
import au.com.dius.pact.support.expressions.ValueResolver;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.cloud.contract.spec.Contract;
import org.springframework.cloud.contract.stubrunner.FromPropsThenFromSysEnv;
import org.springframework.cloud.contract.stubrunner.MappingGenerator;
import org.springframework.cloud.contract.stubrunner.StubConfiguration;
import org.springframework.cloud.contract.stubrunner.StubDownloader;
import org.springframework.cloud.contract.stubrunner.StubRunnerOptions;
import org.springframework.cloud.contract.stubrunner.StubRunnerPropertyUtils;
import org.springframework.cloud.contract.stubrunner.TemporaryFileStorage;
import org.springframework.cloud.contract.verifier.spec.pact.PactContractConverter;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;

class PactStubDownloader
implements StubDownloader {
    private static final String TEMP_DIR_PREFIX = "pact";
    private static final Log log = LogFactory.getLog(PactStubDownloader.class);
    private static final Class CLAZZ = TemporaryFileStorage.class;
    private static final String ARTIFICIAL_NAME_ENDING_WITH_GROOVY = "name.groovy";
    private static final String PROVIDER_NAME_WITH_GROUP_ID = "pactbroker.provider-name-with-group-id";
    private final StubRunnerOptions stubRunnerOptions;
    private final boolean deleteStubsAfterTest;
    private final ObjectMapper objectMapper;

    PactStubDownloader(StubRunnerOptions stubRunnerOptions) {
        this.stubRunnerOptions = stubRunnerOptions;
        this.objectMapper = new ObjectMapper();
        this.deleteStubsAfterTest = stubRunnerOptions.isDeleteStubsAfterTest();
        this.registerShutdownHook();
    }

    public Map.Entry<StubConfiguration, File> downloadAndUnpackStubJar(StubConfiguration stubConfiguration) {
        String version = stubConfiguration.version;
        FromPropsThenFromSysEnv resolver = new FromPropsThenFromSysEnv(this.stubRunnerOptions);
        List<String> tags = this.tags(version, resolver);
        try {
            PactLoader loader = this.pactBrokerLoader(resolver, tags);
            String providerName = this.providerName(stubConfiguration);
            List pacts = loader.load(providerName);
            if (pacts.isEmpty()) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)("No pact definitions found for provider [" + providerName + "]"));
                }
                return null;
            }
            File tmpDirWhereStubsWillBeUnzipped = TemporaryFileStorage.createTempDir((String)TEMP_DIR_PREFIX);
            String coordinatesFolderName = stubConfiguration.getGroupId().replace(".", File.separator) + File.separator + stubConfiguration.getArtifactId();
            File contractsFolder = new File(tmpDirWhereStubsWillBeUnzipped, coordinatesFolderName + File.separator + "contracts");
            File mappingsFolder = new File(tmpDirWhereStubsWillBeUnzipped, coordinatesFolderName + File.separator + "mappings");
            boolean createdContractsDirs = contractsFolder.mkdirs();
            boolean createdMappingsDirs = mappingsFolder.mkdirs();
            if (!createdContractsDirs || !createdMappingsDirs) {
                throw new IllegalStateException("Failed to create mandatory [contracts] or [mappings] folders under [" + coordinatesFolderName + "]");
            }
            this.storePacts(providerName, pacts, contractsFolder, mappingsFolder);
            return new AbstractMap.SimpleEntry<StubConfiguration, File>(stubConfiguration, tmpDirWhereStubsWillBeUnzipped);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private void storePacts(String providerName, List<Pact> pacts, File contractsFolder, File mappingsFolder) {
        for (int i = 0; i < pacts.size(); ++i) {
            String json = this.toJson(pacts.get(i).toMap(PactSpecVersion.V3));
            File file = new File(contractsFolder, i + "_" + providerName.replace(":", "_") + "_pact.json");
            this.storeFile(file.toPath(), json.getBytes());
            try {
                this.storeMapping(mappingsFolder, file);
                continue;
            }
            catch (Exception e) {
                log.warn((Object)"Exception occurred while trying to store the mapping", (Throwable)e);
            }
        }
    }

    private void storeMapping(File mappingsFolder, File file) {
        Collection<Contract> contracts = new PactContractConverter().convertFrom(file);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Converted pact file [" + file + "] to [" + contracts.size() + "] contracts"));
        }
        MappingGenerator.toMappings((File)file, contracts, (File)mappingsFolder);
    }

    private Path storeFile(Path path, byte[] contents) {
        try {
            Path storedPath = Files.write(path, contents, new OpenOption[0]);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Stored file [" + path.toString() + "]"));
            }
            return storedPath;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private String providerName(StubConfiguration stubConfiguration) {
        boolean providerNameWithGroupId = Boolean.parseBoolean(StubRunnerPropertyUtils.getProperty((Map)this.stubRunnerOptions.getProperties(), (String)PROVIDER_NAME_WITH_GROUP_ID));
        if (providerNameWithGroupId) {
            return stubConfiguration.getGroupId() + ":" + stubConfiguration.getArtifactId();
        }
        return stubConfiguration.getArtifactId();
    }

    @NotNull
    PactLoader pactBrokerLoader(final ValueResolver resolver, final List<String> tags) throws IOException {
        Resource repo = this.stubRunnerOptions.getStubRepositoryRoot();
        String schemeSpecificPart = this.schemeSpecificPart(repo.getURI());
        final URI pactBrokerUrl = URI.create(schemeSpecificPart);
        final String stubRunnerUsername = this.stubRunnerOptions.getUsername();
        final String stubRunnerPassword = this.stubRunnerOptions.getPassword();
        return new PactBrokerLoader(new PactBroker(){

            public Class<? extends Annotation> annotationType() {
                return PactBroker.class;
            }

            public String host() {
                return resolver.resolveValue("pactbroker.host:" + pactBrokerUrl.getHost());
            }

            public String port() {
                return resolver.resolveValue("pactbroker.port:" + pactBrokerUrl.getPort());
            }

            public String protocol() {
                return this.scheme();
            }

            public String scheme() {
                return resolver.resolveValue("pactbroker.protocol:" + pactBrokerUrl.getScheme());
            }

            public String[] tags() {
                return tags.toArray(new String[0]);
            }

            public String[] consumers() {
                return new String[]{resolver.resolveValue("pactbroker.consumers:")};
            }

            public boolean failIfNoPactsFound() {
                return true;
            }

            public PactBrokerAuth authentication() {
                return new PactBrokerAuth(){

                    public Class<? extends Annotation> annotationType() {
                        return PactBrokerAuth.class;
                    }

                    public String scheme() {
                        return resolver.resolveValue("pactbroker.auth.scheme:Basic");
                    }

                    public String username() {
                        return resolver.resolveValue("pactbroker.auth.username:" + stubRunnerUsername);
                    }

                    public String password() {
                        return resolver.resolveValue("pactbroker.auth.password:" + stubRunnerPassword);
                    }
                };
            }

            public Class<? extends ValueResolver> valueResolver() {
                return SystemPropertyResolver.class;
            }
        });
    }

    private String schemeSpecificPart(URI uri) {
        String part = uri.getSchemeSpecificPart();
        if (StringUtils.isEmpty((Object)part)) {
            return part;
        }
        return part.startsWith("//") ? part.substring(2) : part;
    }

    @NotNull
    private List<String> tags(String version, ValueResolver resolver) {
        String defaultTag = "+".equals(version) ? "latest" : version;
        return new ArrayList<String>(Arrays.asList(StringUtils.commaDelimitedListToStringArray((String)resolver.resolveValue("pactbroker.tags:" + defaultTag + ""))));
    }

    private String toJson(Map map) {
        try {
            return this.objectMapper.writeValueAsString((Object)map);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
    }

    private void registerShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> TemporaryFileStorage.cleanup((boolean)this.deleteStubsAfterTest)));
    }
}

