/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.maven.verifier;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.springframework.cloud.contract.stubrunner.ContractProjectUpdater;
import org.springframework.cloud.contract.stubrunner.ScmStubDownloaderBuilder;
import org.springframework.cloud.contract.stubrunner.StubRunnerOptions;
import org.springframework.cloud.contract.stubrunner.StubRunnerOptionsBuilder;
import org.springframework.cloud.contract.stubrunner.spring.StubRunnerProperties;
import org.springframework.util.StringUtils;

@Mojo(name="pushStubsToScm")
public class PushStubsToScmMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.build.directory}", readonly=true, required=true)
    private File projectBuildDirectory;
    @Parameter(property="stubsDirectory", defaultValue="${project.build.directory}/stubs")
    private File outputDirectory;
    @Parameter(property="spring.cloud.contract.verifier.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="spring.cloud.contract.verifier.publish-stubs-to-scm.skip", defaultValue="false")
    private boolean taskSkip;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(property="contractsRepositoryUsername")
    private String contractsRepositoryUsername;
    @Parameter(property="contractsRepositoryPassword")
    private String contractsRepositoryPassword;
    @Parameter(property="contractsRepositoryUrl")
    private String contractsRepositoryUrl;
    @Parameter(property="contractsMode", defaultValue="CLASSPATH")
    private StubRunnerProperties.StubsMode contractsMode;
    @Parameter(property="deleteStubsAfterTest", defaultValue="true")
    private boolean deleteStubsAfterTest;
    @Parameter(property="contractsProperties")
    private Map<String, String> contractsProperties = new HashMap<String, String>();

    public void execute() {
        if (this.skip || this.taskSkip) {
            this.getLog().info((CharSequence)("Skipping Spring Cloud Contract Verifier execution: spring.cloud.contract.verifier.skip=" + this.skip + ", spring.cloud.contract.verifier.publish-stubs-to-scm.skip=" + this.taskSkip));
            return;
        }
        if (!StringUtils.hasText((String)this.contractsRepositoryUrl) || !ScmStubDownloaderBuilder.isProtocolAccepted((String)this.contractsRepositoryUrl)) {
            this.getLog().info((CharSequence)"Skipping pushing stubs to scm since your [contractsRepositoryUrl] property doesn't match any of the accepted protocols");
            return;
        }
        String projectName = this.project.getGroupId() + ":" + this.project.getArtifactId() + ":" + this.project.getVersion();
        this.getLog().info((CharSequence)("Pushing Stubs to SCM for project [" + projectName + "]"));
        new ContractProjectUpdater(this.buildOptions()).updateContractProject(projectName, this.outputDirectory.toPath());
    }

    StubRunnerOptions buildOptions() {
        StubRunnerOptionsBuilder builder = new StubRunnerOptionsBuilder().withOptions(StubRunnerOptions.fromSystemProps()).withStubRepositoryRoot(this.contractsRepositoryUrl).withStubsMode(this.contractsMode).withUsername(this.contractsRepositoryUsername).withPassword(this.contractsRepositoryPassword).withDeleteStubsAfterTest(this.deleteStubsAfterTest).withProperties(this.contractsProperties);
        return builder.build();
    }
}

