/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul.serviceregistry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.client.discovery.ManagementServerPortUtils;
import org.springframework.cloud.client.serviceregistry.AutoServiceRegistrationProperties;
import org.springframework.cloud.commons.util.IdUtils;
import org.springframework.cloud.consul.discovery.ConsulDiscoveryProperties;
import org.springframework.cloud.consul.discovery.HeartbeatProperties;
import org.springframework.cloud.consul.model.http.agent.NewService;
import org.springframework.cloud.consul.serviceregistry.ConsulManagementRegistrationCustomizer;
import org.springframework.cloud.consul.serviceregistry.ConsulRegistration;
import org.springframework.cloud.consul.serviceregistry.ConsulRegistrationCustomizer;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class ConsulAutoRegistration
extends ConsulRegistration {
    public static final char SEPARATOR = '-';
    private final AutoServiceRegistrationProperties autoServiceRegistrationProperties;
    private final ApplicationContext context;
    private final HeartbeatProperties heartbeatProperties;
    private final List<ConsulManagementRegistrationCustomizer> managementRegistrationCustomizers;

    @Deprecated
    public ConsulAutoRegistration(NewService service, AutoServiceRegistrationProperties autoServiceRegistrationProperties, ConsulDiscoveryProperties properties, ApplicationContext context, HeartbeatProperties heartbeatProperties) {
        this(service, autoServiceRegistrationProperties, properties, context, heartbeatProperties, Collections.emptyList());
    }

    public ConsulAutoRegistration(NewService service, AutoServiceRegistrationProperties autoServiceRegistrationProperties, ConsulDiscoveryProperties properties, ApplicationContext context, HeartbeatProperties heartbeatProperties, List<ConsulManagementRegistrationCustomizer> managementRegistrationCustomizers) {
        super(service, properties);
        this.autoServiceRegistrationProperties = autoServiceRegistrationProperties;
        this.context = context;
        this.heartbeatProperties = heartbeatProperties;
        this.managementRegistrationCustomizers = managementRegistrationCustomizers;
    }

    public static ConsulAutoRegistration registration(AutoServiceRegistrationProperties autoServiceRegistrationProperties, ConsulDiscoveryProperties properties, ApplicationContext context, List<ConsulRegistrationCustomizer> registrationCustomizers, List<ConsulManagementRegistrationCustomizer> managementRegistrationCustomizers, HeartbeatProperties heartbeatProperties) {
        NewService service = new NewService();
        String appName = ConsulAutoRegistration.getAppName(properties, context.getEnvironment());
        service.setId(ConsulAutoRegistration.getInstanceId(properties, context));
        if (!properties.isPreferAgentAddress()) {
            service.setAddress(properties.getHostname());
        }
        service.setName(ConsulAutoRegistration.normalizeForDns(appName));
        service.setTags(new ArrayList<String>(properties.getTags()));
        service.setEnableTagOverride(properties.getEnableTagOverride());
        service.setMeta(ConsulAutoRegistration.getMetadata(properties));
        if (properties.getPort() != null) {
            service.setPort(properties.getPort());
            ConsulAutoRegistration.setCheck(service, autoServiceRegistrationProperties, properties, context, heartbeatProperties);
        }
        ConsulAutoRegistration registration = new ConsulAutoRegistration(service, autoServiceRegistrationProperties, properties, context, heartbeatProperties, managementRegistrationCustomizers);
        ConsulAutoRegistration.customize(registrationCustomizers, registration);
        return registration;
    }

    public static void customize(List<ConsulRegistrationCustomizer> registrationCustomizers, ConsulAutoRegistration registration) {
        if (registrationCustomizers != null) {
            for (ConsulRegistrationCustomizer customizer : registrationCustomizers) {
                customizer.customize(registration);
            }
        }
    }

    public static void setCheck(NewService service, AutoServiceRegistrationProperties autoServiceRegistrationProperties, ConsulDiscoveryProperties properties, ApplicationContext context, HeartbeatProperties heartbeatProperties) {
        if (properties.isRegisterHealthCheck() && service.getCheck() == null) {
            Integer checkPort = ConsulAutoRegistration.shouldRegisterManagement(autoServiceRegistrationProperties, properties, context) ? ConsulAutoRegistration.getManagementPort(properties, context) : service.getPort();
            Assert.notNull((Object)checkPort, (String)"checkPort may not be null");
            service.setCheck(ConsulAutoRegistration.createCheck(checkPort, heartbeatProperties, properties));
        }
    }

    public static ConsulAutoRegistration managementRegistration(AutoServiceRegistrationProperties autoServiceRegistrationProperties, ConsulDiscoveryProperties properties, ApplicationContext context, List<ConsulManagementRegistrationCustomizer> managementRegistrationCustomizers, HeartbeatProperties heartbeatProperties) {
        NewService management = new NewService();
        management.setId(ConsulAutoRegistration.getManagementServiceId(properties, context));
        management.setAddress(properties.getHostname());
        management.setName(ConsulAutoRegistration.getManagementServiceName(properties, context.getEnvironment()));
        management.setPort(ConsulAutoRegistration.getManagementPort(properties, context));
        management.setTags(properties.getManagementTags());
        management.setEnableTagOverride(properties.getManagementEnableTagOverride());
        management.setMeta(properties.getManagementMetadata());
        if (properties.isRegisterHealthCheck()) {
            management.setCheck(ConsulAutoRegistration.createCheck(ConsulAutoRegistration.getManagementPort(properties, context), heartbeatProperties, properties));
        }
        ConsulAutoRegistration registration = new ConsulAutoRegistration(management, autoServiceRegistrationProperties, properties, context, heartbeatProperties, managementRegistrationCustomizers);
        ConsulAutoRegistration.managementCustomize(managementRegistrationCustomizers, registration);
        return registration;
    }

    public static void managementCustomize(List<ConsulManagementRegistrationCustomizer> registrationCustomizers, ConsulAutoRegistration registration) {
        if (registrationCustomizers != null) {
            for (ConsulManagementRegistrationCustomizer customizer : registrationCustomizers) {
                customizer.customize(registration);
            }
        }
    }

    public static String getInstanceId(ConsulDiscoveryProperties properties, ApplicationContext context) {
        if (!StringUtils.hasText((String)properties.getInstanceId())) {
            return ConsulAutoRegistration.normalizeForDns(IdUtils.getDefaultInstanceId((PropertyResolver)context.getEnvironment(), (boolean)properties.isIncludeHostnameInInstanceId()));
        }
        return ConsulAutoRegistration.normalizeForDns(properties.getInstanceId());
    }

    public static String normalizeForDns(String s) {
        if (s == null || !Character.isLetter(s.charAt(0)) || !Character.isLetterOrDigit(s.charAt(s.length() - 1))) {
            throw new IllegalArgumentException("Consul service ids must not be empty, must start with a letter, end with a letter or digit, and have as interior characters only letters, digits, and hyphen: " + s);
        }
        StringBuilder normalized = new StringBuilder();
        Character prev = null;
        for (char curr : s.toCharArray()) {
            Character toAppend = null;
            if (Character.isLetterOrDigit(curr)) {
                toAppend = Character.valueOf(curr);
            } else if (prev == null || prev.charValue() != '-') {
                toAppend = Character.valueOf('-');
            }
            if (toAppend == null) continue;
            normalized.append(toAppend);
            prev = toAppend;
        }
        return normalized.toString();
    }

    private static Map<String, String> getMetadata(ConsulDiscoveryProperties properties) {
        LinkedHashMap<String, String> metadata = new LinkedHashMap<String, String>();
        if (!CollectionUtils.isEmpty(properties.getMetadata())) {
            metadata.putAll(properties.getMetadata());
        }
        if (!ObjectUtils.isEmpty((Object)properties.getInstanceZone())) {
            metadata.put(properties.getDefaultZoneMetadataName(), properties.getInstanceZone());
        }
        if (!ObjectUtils.isEmpty((Object)properties.getInstanceGroup())) {
            metadata.put("group", properties.getInstanceGroup());
        }
        metadata.put("secure", Boolean.toString(properties.getScheme().equalsIgnoreCase("https")));
        return metadata;
    }

    public static NewService.Check createCheck(Integer port, HeartbeatProperties ttlConfig, ConsulDiscoveryProperties properties) {
        NewService.Check check = new NewService.Check();
        if (StringUtils.hasText((String)properties.getHealthCheckCriticalTimeout())) {
            check.setDeregisterCriticalServiceAfter(properties.getHealthCheckCriticalTimeout());
        }
        if (ttlConfig.isEnabled()) {
            check.setTtl(ttlConfig.getTtl().getSeconds() + "s");
            return check;
        }
        Assert.notNull((Object)port, (String)"createCheck port must not be null");
        Assert.isTrue((port > 0 ? 1 : 0) != 0, (String)"createCheck port must be greater than 0");
        if (properties.getHealthCheckUrl() != null) {
            check.setHttp(properties.getHealthCheckUrl());
        } else {
            check.setHttp(String.format("%s://%s:%s%s", properties.getScheme(), properties.getHostname(), port, properties.getHealthCheckPath()));
        }
        check.setHeader(properties.getHealthCheckHeaders());
        check.setInterval(properties.getHealthCheckInterval());
        check.setTimeout(properties.getHealthCheckTimeout());
        check.setTlsSkipVerify(properties.getHealthCheckTlsSkipVerify());
        return check;
    }

    public static String getAppName(ConsulDiscoveryProperties properties, Environment env) {
        String appName = properties.getServiceName();
        if (StringUtils.hasText((String)appName)) {
            return appName;
        }
        return env.getProperty("spring.application.name", "application");
    }

    public static boolean shouldRegisterManagement(AutoServiceRegistrationProperties autoServiceRegistrationProperties, ConsulDiscoveryProperties properties, ApplicationContext context) {
        return autoServiceRegistrationProperties.isRegisterManagement() && ConsulAutoRegistration.getManagementPort(properties, context) != null && ManagementServerPortUtils.isDifferent((BeanFactory)context);
    }

    public static String getManagementServiceId(ConsulDiscoveryProperties properties, ApplicationContext context) {
        String instanceId = properties.getInstanceId();
        if (StringUtils.hasText((String)instanceId)) {
            return ConsulAutoRegistration.normalizeForDns(instanceId + "-" + properties.getManagementSuffix());
        }
        return ConsulAutoRegistration.normalizeForDns(IdUtils.getDefaultInstanceId((PropertyResolver)context.getEnvironment(), (boolean)false)) + "-" + properties.getManagementSuffix();
    }

    public static String getManagementServiceName(ConsulDiscoveryProperties properties, Environment env) {
        String appName = properties.getServiceName();
        if (StringUtils.hasText((String)appName)) {
            return ConsulAutoRegistration.normalizeForDns(appName + "-" + properties.getManagementSuffix());
        }
        return ConsulAutoRegistration.normalizeForDns(ConsulAutoRegistration.getAppName(properties, env)) + "-" + properties.getManagementSuffix();
    }

    public static Integer getManagementPort(ConsulDiscoveryProperties properties, ApplicationContext context) {
        if (properties.getManagementPort() != null) {
            return properties.getManagementPort();
        }
        return ManagementServerPortUtils.getPort((BeanFactory)context);
    }

    public void initializePort(int knownPort) {
        if (this.getService().getPort() == null) {
            this.getService().setPort(Integer.valueOf(knownPort));
        }
        ConsulAutoRegistration.setCheck(this.getService(), this.autoServiceRegistrationProperties, this.getProperties(), this.context, this.heartbeatProperties);
    }

    public ConsulAutoRegistration managementRegistration() {
        return ConsulAutoRegistration.managementRegistration(this.autoServiceRegistrationProperties, this.getProperties(), this.context, this.managementRegistrationCustomizers, this.heartbeatProperties);
    }
}

