/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul.discovery;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.consul.ConsulClient;
import org.springframework.cloud.consul.discovery.ConsulDiscoveryProperties;
import org.springframework.cloud.consul.discovery.ConsulServiceInstance;
import org.springframework.cloud.consul.model.http.health.HealthService;
import org.springframework.http.ResponseEntity;

public class ConsulDiscoveryClient
implements DiscoveryClient {
    private final ConsulClient client;
    private final ConsulDiscoveryProperties properties;

    public ConsulDiscoveryClient(ConsulClient client, ConsulDiscoveryProperties properties) {
        this.client = client;
        this.properties = properties;
    }

    public String description() {
        return "Spring Cloud Consul Discovery Client";
    }

    public List<ServiceInstance> getInstances(String serviceId) {
        ConsulDiscoveryProperties.ConsistencyMode consistencyModeProp = this.properties.getConsistencyMode();
        ConsulClient.ConsistencyMode consistencyMode = ConsulClient.ConsistencyMode.DEFAULT;
        if (consistencyModeProp != null) {
            consistencyMode = ConsulClient.ConsistencyMode.valueOf((String)consistencyModeProp.name().toUpperCase(Locale.ROOT));
        }
        return this.getInstances(serviceId, new ConsulClient.QueryParams(consistencyMode));
    }

    public List<ServiceInstance> getInstances(String serviceId, ConsulClient.QueryParams queryParams) {
        ArrayList<ServiceInstance> instances = new ArrayList<ServiceInstance>();
        this.addInstancesToList(instances, serviceId, queryParams);
        return instances;
    }

    private void addInstancesToList(List<ServiceInstance> instances, String serviceId, ConsulClient.QueryParams queryParams) {
        String[] queryTags = this.properties.getQueryTagsForService(serviceId);
        List<String> tags = null;
        if (queryTags != null) {
            tags = Arrays.asList(queryTags);
        }
        ResponseEntity healthServices = this.client.getHealthServices(serviceId, this.properties.isQueryPassing(), this.properties.getAclToken(), tags, queryParams);
        for (HealthService service : (List)healthServices.getBody()) {
            instances.add((ServiceInstance)new ConsulServiceInstance(service, serviceId));
        }
    }

    public List<ServiceInstance> getAllInstances() {
        ArrayList<ServiceInstance> instances = new ArrayList<ServiceInstance>();
        Map catalogServices = (Map)this.client.getCatalogServices(this.properties.getAclToken(), ConsulClient.QueryParams.DEFAULT).getBody();
        for (String serviceId : catalogServices.keySet()) {
            this.addInstancesToList(instances, serviceId, null);
        }
        return instances;
    }

    public List<String> getServices() {
        Map catalogServices = (Map)this.client.getCatalogServices(this.properties.getAclToken(), ConsulClient.QueryParams.DEFAULT).getBody();
        return new ArrayList<String>(catalogServices.keySet());
    }

    public void probe() {
        this.client.getStatusLeader();
    }

    public int getOrder() {
        return this.properties.getOrder();
    }
}

