/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul.discovery;

import com.netflix.loadbalancer.Server;
import java.util.Map;
import org.springframework.cloud.consul.discovery.ConsulServer;
import org.springframework.cloud.netflix.ribbon.DefaultServerIntrospector;

public class ConsulServerIntrospector
extends DefaultServerIntrospector {
    public boolean isSecure(Server server) {
        Map<String, String> metadata = this.getMetadata(server);
        if (metadata != null && metadata.containsKey("secure")) {
            return metadata.getOrDefault("secure", "false").equalsIgnoreCase("true");
        }
        return super.isSecure(server);
    }

    public Map<String, String> getMetadata(Server server) {
        if (server instanceof ConsulServer) {
            ConsulServer consulServer = (ConsulServer)server;
            return consulServer.getMetadata();
        }
        return super.getMetadata(server);
    }
}

