/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul.config;

import org.springframework.boot.BootstrapRegistry;
import org.springframework.boot.Bootstrapper;
import org.springframework.boot.context.config.ConfigData;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.cloud.consul.RetryProperties;
import org.springframework.cloud.consul.config.ConsulBootstrapper;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.ClassUtils;

public class ConsulRetryBootstrapper
implements Bootstrapper {
    static final boolean RETRY_IS_PRESENT = ClassUtils.isPresent((String)"org.springframework.retry.annotation.Retryable", null);

    public void intitialize(BootstrapRegistry registry) {
        if (!RETRY_IS_PRESENT) {
            return;
        }
        registry.registerIfAbsent(RetryProperties.class, context -> (RetryProperties)((Binder)context.get(Binder.class)).bind("spring.cloud.consul.retry", RetryProperties.class).orElseGet(RetryProperties::new));
        registry.registerIfAbsent(RetryTemplate.class, context -> {
            RetryProperties properties = (RetryProperties)context.get(RetryProperties.class);
            if (properties.isEnabled()) {
                return RetryTemplate.builder().maxAttempts(properties.getMaxAttempts()).exponentialBackoff(properties.getInitialInterval(), properties.getMultiplier(), properties.getMaxInterval()).build();
            }
            return null;
        });
        registry.registerIfAbsent(ConsulBootstrapper.LoaderInterceptor.class, context -> {
            RetryTemplate retryTemplate = (RetryTemplate)context.get(RetryTemplate.class);
            if (retryTemplate != null) {
                return loadContext -> (ConfigData)retryTemplate.execute(retryContext -> (ConfigData)loadContext.getInvocation().apply(loadContext.getLoaderContext(), loadContext.getResource()));
            }
            return null;
        });
    }
}

