/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul.config;

import com.ecwid.consul.v1.ConsulClient;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.springframework.boot.context.config.ConfigData;
import org.springframework.boot.context.config.ConfigDataLoader;
import org.springframework.boot.context.config.ConfigDataLoaderContext;
import org.springframework.boot.context.config.ConfigDataResource;
import org.springframework.boot.context.config.ConfigDataResourceNotFoundException;
import org.springframework.cloud.consul.config.ConsulConfigDataResource;
import org.springframework.cloud.consul.config.ConsulConfigIndexes;
import org.springframework.cloud.consul.config.ConsulPropertySource;

public class ConsulConfigDataLoader
implements ConfigDataLoader<ConsulConfigDataResource> {
    private final Log log;

    public ConsulConfigDataLoader(Log log) {
        this.log = log;
    }

    public ConfigData load(ConfigDataLoaderContext context, ConsulConfigDataResource resource) {
        try {
            ConsulClient consul = this.getBean(context, ConsulClient.class);
            ConsulConfigIndexes indexes = this.getBean(context, ConsulConfigIndexes.class);
            ConsulPropertySource propertySource = resource.getConsulPropertySources().createPropertySource(resource.getContext(), resource.isOptional(), consul, indexes.getIndexes()::put);
            return new ConfigData(Collections.singletonList(propertySource), new ConfigData.Option[0]);
        }
        catch (Exception e) {
            throw new ConfigDataResourceNotFoundException((ConfigDataResource)resource, (Throwable)e);
        }
    }

    protected <T> T getBean(ConfigDataLoaderContext context, Class<T> type) {
        if (context.getBootstrapContext().isRegistered(type)) {
            return (T)context.getBootstrapContext().get(type);
        }
        return null;
    }
}

