/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul.config;

import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.QueryParams;
import com.ecwid.consul.v1.Response;
import java.beans.ConstructorProperties;
import java.io.Closeable;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.PostConstruct;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.consul.config.ConsulConfigProperties;
import org.springframework.cloud.endpoint.event.RefreshEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class ConfigWatch
implements Closeable,
ApplicationEventPublisherAware {
    private static final Log log = LogFactory.getLog(ConfigWatch.class);
    private final ConsulConfigProperties properties;
    private final List<String> contexts;
    private final ConsulClient consul;
    private AtomicBoolean running = new AtomicBoolean(false);
    private ApplicationEventPublisher publisher;
    private HashMap<String, Long> consulIndexes = new HashMap();
    private Boolean initialized = false;

    public ConfigWatch(ConsulConfigProperties properties, List<String> contexts, ConsulClient consul) {
        this.properties = properties;
        this.contexts = contexts;
        this.consul = consul;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    @PostConstruct
    public void start() {
        this.running.compareAndSet(false, true);
    }

    @Scheduled(fixedDelayString="${spring.cloud.consul.config.watch.delay:1000}")
    public void watchConfigKeyValues() {
        if (this.running.get()) {
            for (String context : this.contexts) {
                if (this.properties.getFormat() != ConsulConfigProperties.Format.FILES && !context.endsWith("/")) {
                    context = context + "/";
                }
                try {
                    Long newIndex;
                    Response response;
                    String aclToken;
                    Long currentIndex = this.consulIndexes.get(context);
                    if (currentIndex == null) {
                        currentIndex = -1L;
                    }
                    if (StringUtils.isEmpty((Object)(aclToken = this.properties.getAclToken()))) {
                        aclToken = null;
                    }
                    if ((response = this.consul.getKVValues(context, aclToken, new QueryParams((long)this.properties.getWatch().getWaitTime(), currentIndex.longValue()))).getValue() == null || ((List)response.getValue()).isEmpty() || (newIndex = response.getConsulIndex()) == null || newIndex.equals(currentIndex)) continue;
                    if (!this.consulIndexes.containsValue(newIndex) && !currentIndex.equals(-1L)) {
                        RefreshEventData data = new RefreshEventData(context, currentIndex, newIndex);
                        this.publisher.publishEvent((ApplicationEvent)new RefreshEvent((Object)this, (Object)data, data.toString()));
                    }
                    this.consulIndexes.put(context, newIndex);
                }
                catch (Exception e) {
                    if (!this.initialized.booleanValue() && this.properties.isFailFast()) {
                        log.error((Object)"Fail fast is set and there was an error reading configuration from consul.");
                        ReflectionUtils.rethrowRuntimeException((Throwable)e);
                        continue;
                    }
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Error querying consul Key/Values for context '" + context + "'"), (Throwable)e);
                        continue;
                    }
                    if (!log.isWarnEnabled()) continue;
                    log.warn((Object)("Error querying consul Key/Values for context '" + context + "'. Message: " + e.getMessage()));
                }
            }
        }
        this.initialized = true;
    }

    @Override
    public void close() {
        this.running.compareAndSet(true, false);
    }

    HashMap<String, Long> getConsulIndexes() {
        return this.consulIndexes;
    }

    static class RefreshEventData {
        private final String context;
        private final Long prevIndex;
        private final Long newIndex;

        @ConstructorProperties(value={"context", "prevIndex", "newIndex"})
        public RefreshEventData(String context, Long prevIndex, Long newIndex) {
            this.context = context;
            this.prevIndex = prevIndex;
            this.newIndex = newIndex;
        }

        public String getContext() {
            return this.context;
        }

        public Long getPrevIndex() {
            return this.prevIndex;
        }

        public Long getNewIndex() {
            return this.newIndex;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RefreshEventData)) {
                return false;
            }
            RefreshEventData other = (RefreshEventData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$context = this.getContext();
            String other$context = other.getContext();
            if (this$context == null ? other$context != null : !this$context.equals(other$context)) {
                return false;
            }
            Long this$prevIndex = this.getPrevIndex();
            Long other$prevIndex = other.getPrevIndex();
            if (this$prevIndex == null ? other$prevIndex != null : !((Object)this$prevIndex).equals(other$prevIndex)) {
                return false;
            }
            Long this$newIndex = this.getNewIndex();
            Long other$newIndex = other.getNewIndex();
            return !(this$newIndex == null ? other$newIndex != null : !((Object)this$newIndex).equals(other$newIndex));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RefreshEventData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $context = this.getContext();
            result = result * 59 + ($context == null ? 43 : $context.hashCode());
            Long $prevIndex = this.getPrevIndex();
            result = result * 59 + ($prevIndex == null ? 43 : ((Object)$prevIndex).hashCode());
            Long $newIndex = this.getNewIndex();
            result = result * 59 + ($newIndex == null ? 43 : ((Object)$newIndex).hashCode());
            return result;
        }

        public String toString() {
            return "ConfigWatch.RefreshEventData(context=" + this.getContext() + ", prevIndex=" + this.getPrevIndex() + ", newIndex=" + this.getNewIndex() + ")";
        }
    }
}

