/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul.binder;

import jakarta.annotation.PostConstruct;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.cloud.consul.ConsulClient;
import org.springframework.cloud.consul.binder.config.ConsulBinderProperties;
import org.springframework.cloud.consul.model.http.ConsulHeaders;
import org.springframework.cloud.consul.model.http.event.Event;
import org.springframework.http.ResponseEntity;
import tools.jackson.databind.ObjectMapper;

public class EventService {
    protected ConsulBinderProperties properties;
    protected ConsulClient consul;
    protected ObjectMapper objectMapper = new ObjectMapper();
    private AtomicReference<Long> lastIndex = new AtomicReference();

    public EventService(ConsulBinderProperties properties, ConsulClient consul, ObjectMapper objectMapper) {
        this.properties = properties;
        this.consul = consul;
        this.objectMapper = objectMapper;
    }

    public ConsulClient getConsulClient() {
        return this.consul;
    }

    @PostConstruct
    public void init() {
        this.setLastIndex(this.getEventsResponse());
    }

    public Long getLastIndex() {
        return this.lastIndex.get();
    }

    private void setLastIndex(ResponseEntity<?> response) {
        Long consulIndex = ConsulHeaders.getConsulIndex(response);
        if (consulIndex != null) {
            this.lastIndex.set(consulIndex);
        }
    }

    public Event fire(String name, String payload) {
        ResponseEntity response = this.consul.eventFire(name, payload);
        return (Event)response.getBody();
    }

    public ResponseEntity<List<Event>> getEventsResponse() {
        return this.consul.eventList();
    }

    public List<Event> getEvents() {
        return (List)this.getEventsResponse().getBody();
    }

    public List<Event> getEvents(Long lastIndex) {
        return this.filterEvents(this.readEvents(this.getEventsResponse()), lastIndex);
    }

    public List<Event> watch() {
        return this.watch(this.lastIndex.get());
    }

    public List<Event> watch(Long lastIndex) {
        long index = -1L;
        if (lastIndex != null) {
            index = lastIndex;
        }
        int eventTimeout = 5;
        if (this.properties != null) {
            eventTimeout = this.properties.getEventTimeout();
        }
        ResponseEntity watch = this.consul.eventList(eventTimeout, index);
        return this.filterEvents(this.readEvents((ResponseEntity<List<Event>>)watch), lastIndex);
    }

    protected List<Event> readEvents(ResponseEntity<List<Event>> response) {
        this.setLastIndex(response);
        return (List)response.getBody();
    }

    protected List<Event> filterEvents(List<Event> toFilter, Long lastIndex) {
        List<Event> events = toFilter;
        if (lastIndex != null) {
            for (int i = 0; i < events.size(); ++i) {
                Event event = events.get(i);
                Long eventIndex = event.getWaitIndex();
                if (!lastIndex.equals(eventIndex)) continue;
                events = events.subList(i + 1, events.size());
                break;
            }
        }
        return events;
    }
}

