/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul.binder;

import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.QueryParams;
import com.ecwid.consul.v1.Response;
import com.ecwid.consul.v1.event.model.EventParams;
import java.util.Arrays;
import org.springframework.integration.handler.AbstractMessageHandler;
import org.springframework.messaging.Message;

public class ConsulSendingHandler
extends AbstractMessageHandler {
    private final ConsulClient consul;
    private final String eventName;

    public ConsulSendingHandler(ConsulClient consul, String eventName) {
        this.consul = consul;
        this.eventName = eventName;
    }

    protected void handleMessageInternal(Message<?> message) {
        Object payload;
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Publishing message" + message));
        }
        if ((payload = message.getPayload()) instanceof byte[]) {
            payload = Arrays.toString((byte[])payload);
        }
        Response event = this.consul.eventFire(this.eventName, (String)payload, new EventParams(), QueryParams.DEFAULT);
    }
}

