/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.encryption;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.server.encryption.AbstractCipherResourceEncryptor;
import org.springframework.cloud.config.server.encryption.ResourceEncryptor;
import org.springframework.cloud.config.server.encryption.TextEncryptorLocator;
import org.springframework.stereotype.Component;
import tools.jackson.dataformat.yaml.YAMLFactory;

@Component
public class CipherResourceYamlEncryptor
extends AbstractCipherResourceEncryptor
implements ResourceEncryptor {
    private static final List<String> SUPPORTED_EXTENSIONS = Arrays.asList("yml", "yaml");
    private final YAMLFactory factory = new YAMLFactory();

    public CipherResourceYamlEncryptor(TextEncryptorLocator encryptor) {
        super(encryptor);
    }

    @Override
    public List<String> getSupportedExtensions() {
        return SUPPORTED_EXTENSIONS;
    }

    @Override
    public String decrypt(String text, Environment environment) throws IOException {
        return this.decryptWithJacksonParser(text, environment.getName(), environment.getProfiles(), this.factory);
    }
}

