/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Consumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.environment.PropertySource;
import org.springframework.cloud.config.server.config.ConfigServerProperties;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;
import org.springframework.cloud.config.server.environment.JsonS3ConfigFile;
import org.springframework.cloud.config.server.environment.NonProfileSpecificYamlDocumentS3ConfigFile;
import org.springframework.cloud.config.server.environment.ProfileSpecificYamlDocumentS3ConfigFile;
import org.springframework.cloud.config.server.environment.ProfileSpecificYamlS3ConfigFile;
import org.springframework.cloud.config.server.environment.PropertyS3ConfigFile;
import org.springframework.cloud.config.server.environment.S3ConfigFile;
import org.springframework.cloud.config.server.environment.SearchPathLocator;
import org.springframework.cloud.config.server.environment.YamlS3ConfigFile;
import org.springframework.core.Ordered;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import software.amazon.awssdk.services.s3.S3Client;

public class AwsS3EnvironmentRepository
implements EnvironmentRepository,
Ordered,
SearchPathLocator {
    protected static final String PATH_SEPARATOR = "/";
    private static final Log LOG = LogFactory.getLog(AwsS3EnvironmentRepository.class);
    private static final String AWS_S3_RESOURCE_SCHEME = "s3://";
    private final S3Client s3Client;
    private final String bucketName;
    private final ConfigServerProperties serverProperties;
    protected int order = Integer.MAX_VALUE;

    public AwsS3EnvironmentRepository(S3Client s3Client, String bucketName, ConfigServerProperties server) {
        this.s3Client = s3Client;
        this.bucketName = bucketName;
        this.serverProperties = server;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    @Override
    public Environment findOne(String specifiedApplication, String specifiedProfiles, String specifiedLabel) {
        String application = ObjectUtils.isEmpty((Object)specifiedApplication) ? this.serverProperties.getDefaultApplicationName() : specifiedApplication;
        String profiles = ObjectUtils.isEmpty((Object)specifiedProfiles) ? this.serverProperties.getDefaultProfile() : specifiedProfiles;
        String label = ObjectUtils.isEmpty((Object)specifiedLabel) ? this.serverProperties.getDefaultLabel() : specifiedLabel;
        String[] profileArray = this.parseProfiles(profiles);
        List<String> apps = Arrays.asList(StringUtils.commaDelimitedListToStringArray((String)application.replace(" ", "")));
        if (!apps.contains(this.serverProperties.getDefaultApplicationName())) {
            apps = new ArrayList<String>(apps);
            apps.add(this.serverProperties.getDefaultApplicationName());
        }
        Environment environment = new Environment(application, profileArray);
        environment.setLabel(label);
        this.addPropertySources(environment, apps, profileArray, label);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Returning Environment: " + environment));
        }
        return environment;
    }

    private void addPropertySources(Environment environment, List<String> apps, String[] profiles, String label) {
        for (String profile : profiles) {
            this.addPropertySourcesForApps(apps, app -> this.addProfileSpecificPropertySource(environment, (String)app, profile, label));
        }
        if (profiles.length == 0) {
            this.addPropertySourcesForApps(apps, app -> this.addNonProfileSpecificPropertySource(environment, (String)app, null, label));
        } else {
            for (String profile : profiles) {
                this.addPropertySourcesForApps(apps, app -> this.addNonProfileSpecificPropertySource(environment, (String)app, profile, label));
            }
        }
    }

    private void addPropertySourcesForApps(List<String> apps, Consumer<String> addPropertySource) {
        apps.forEach(addPropertySource);
    }

    private void addProfileSpecificPropertySource(Environment environment, String app, String profile, String label) {
        List<S3ConfigFile> s3ConfigFiles = this.getS3ConfigFile(app, profile, label, this::getS3PropertiesOrJsonConfigFile, this::getProfileSpecificS3ConfigFileYaml);
        this.addPropertySource(environment, s3ConfigFiles);
    }

    private void addNonProfileSpecificPropertySource(Environment environment, String app, String profile, String label) {
        List<S3ConfigFile> s3ConfigFiles = this.getS3ConfigFile(app, profile, label, this::getNonProfileSpecificPropertiesOrJsonConfigFile, this::getNonProfileSpecificS3ConfigFileYaml);
        this.addPropertySource(environment, s3ConfigFiles);
    }

    private void addPropertySource(Environment environment, List<S3ConfigFile> s3ConfigFiles) {
        for (S3ConfigFile s3ConfigFile : s3ConfigFiles) {
            Properties config = s3ConfigFile.read();
            if (config == null || config.isEmpty() && !s3ConfigFile.isShouldIncludeWithEmptyProperties()) continue;
            environment.setVersion(s3ConfigFile.getVersion());
            config.putAll(this.serverProperties.getOverrides());
            PropertySource propertySource = new PropertySource(s3ConfigFile.getName(), (Map)config);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Adding property source to environment " + propertySource));
            }
            environment.add(propertySource);
        }
    }

    private String[] parseProfiles(String profiles) {
        return StringUtils.commaDelimitedListToStringArray((String)profiles);
    }

    private List<S3ConfigFile> getS3ConfigFile(String application, String profile, String label, JsonOrPropertiesS3ConfigFileCreator creator, YamlS3ConfigFileCreator yamlCreator) {
        S3ConfigFile configFile = creator.create(application, profile, label);
        if (configFile != null) {
            return List.of(configFile);
        }
        return new ArrayList<S3ConfigFile>(yamlCreator.create(application, profile, label));
    }

    private List<YamlS3ConfigFile> getNonProfileSpecificS3ConfigFileYaml(String application, String profile, String label) {
        ArrayList<YamlS3ConfigFile> configFiles;
        block6: {
            block5: {
                configFiles = new ArrayList<YamlS3ConfigFile>();
                if (profile != null) {
                    try {
                        ProfileSpecificYamlDocumentS3ConfigFile configFileDocument = new ProfileSpecificYamlDocumentS3ConfigFile(application, profile, label, this.bucketName, this.s3Client);
                        configFileDocument.setShouldIncludeWithEmptyProperties(false);
                        configFiles.add(configFileDocument);
                    }
                    catch (Exception e) {
                        if (!LOG.isDebugEnabled()) break block5;
                        LOG.debug((Object)("Did not find specific yaml document in non-profile specific file using application <" + application + "> profile <" + profile + "> label <" + label + ">."));
                    }
                }
            }
            try {
                NonProfileSpecificYamlDocumentS3ConfigFile configFile = new NonProfileSpecificYamlDocumentS3ConfigFile(application, null, label, this.bucketName, this.s3Client);
                configFiles.add(configFile);
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block6;
                LOG.debug((Object)("Did not find non-profile specific yaml document in non-profile specific file using application <" + application + "> profile <null> label <" + label + ">."));
            }
        }
        return configFiles;
    }

    private List<YamlS3ConfigFile> getProfileSpecificS3ConfigFileYaml(String application, String profile, String label) {
        try {
            ProfileSpecificYamlS3ConfigFile configFile = new ProfileSpecificYamlS3ConfigFile(application, profile, label, this.bucketName, this.s3Client);
            return List.of(configFile);
        }
        catch (Exception e) {
            LOG.warn((Object)"Could not read YAML file", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private S3ConfigFile getNonProfileSpecificPropertiesOrJsonConfigFile(String application, String profile, String label) {
        return this.getS3PropertiesOrJsonConfigFile(application, null, label);
    }

    private S3ConfigFile getS3PropertiesOrJsonConfigFile(String application, String profile, String label) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting S3 config file for " + application + " " + profile + " " + label));
        }
        try {
            return new PropertyS3ConfigFile(application, profile, label, this.bucketName, this.s3Client);
        }
        catch (Exception propertyException) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Did not find properties file using application <" + application + "> profile <" + profile + "> label <" + label + ">.  Trying json extension"), (Throwable)propertyException);
            }
            try {
                return new JsonS3ConfigFile(application, profile, label, this.bucketName, this.s3Client);
            }
            catch (Exception jsonException) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Did not find json file using application <" + application + "> profile <" + profile + "> label <" + label + ">.  Trying yaml extension"), (Throwable)jsonException);
                }
                return null;
            }
        }
    }

    @Override
    public SearchPathLocator.Locations getLocations(String application, String profiles, String label) {
        StringBuilder baseLocation = new StringBuilder(AWS_S3_RESOURCE_SCHEME + this.bucketName + PATH_SEPARATOR);
        if (!StringUtils.hasText((String)label) && StringUtils.hasText((String)this.serverProperties.getDefaultLabel())) {
            label = this.serverProperties.getDefaultLabel();
        }
        if (StringUtils.hasText((String)label)) {
            baseLocation.append(label);
        }
        return new SearchPathLocator.Locations(application, profiles, label, null, new String[]{baseLocation.toString()});
    }

    static interface JsonOrPropertiesS3ConfigFileCreator {
        public S3ConfigFile create(String var1, String var2, String var3);
    }

    static interface YamlS3ConfigFileCreator {
        public List<YamlS3ConfigFile> create(String var1, String var2, String var3);
    }
}

