/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import com.amazonaws.services.simplesystemsmanagement.AWSSimpleSystemsManagement;
import com.amazonaws.services.simplesystemsmanagement.AWSSimpleSystemsManagementClientBuilder;
import org.springframework.cloud.config.server.config.ConfigServerProperties;
import org.springframework.cloud.config.server.environment.AwsClientBuilderConfigurer;
import org.springframework.cloud.config.server.environment.AwsParameterStoreEnvironmentProperties;
import org.springframework.cloud.config.server.environment.AwsParameterStoreEnvironmentRepository;
import org.springframework.cloud.config.server.environment.EnvironmentRepositoryFactory;

public class AwsParameterStoreEnvironmentRepositoryFactory
implements EnvironmentRepositoryFactory<AwsParameterStoreEnvironmentRepository, AwsParameterStoreEnvironmentProperties> {
    private final ConfigServerProperties configServerProperties;

    public AwsParameterStoreEnvironmentRepositoryFactory(ConfigServerProperties configServerProperties) {
        this.configServerProperties = configServerProperties;
    }

    @Override
    public AwsParameterStoreEnvironmentRepository build(AwsParameterStoreEnvironmentProperties environmentProperties) {
        AWSSimpleSystemsManagementClientBuilder clientBuilder = AWSSimpleSystemsManagementClientBuilder.standard();
        AwsClientBuilderConfigurer.configureClientBuilder(clientBuilder, environmentProperties.getRegion(), environmentProperties.getEndpoint());
        AWSSimpleSystemsManagement client = (AWSSimpleSystemsManagement)clientBuilder.build();
        return new AwsParameterStoreEnvironmentRepository(client, this.configServerProperties, environmentProperties);
    }
}

