/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.test;

import java.io.File;
import java.io.IOException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryCache;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.FileUtils;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.environment.PropertySource;
import org.springframework.util.FileSystemUtils;
import org.springframework.util.StringUtils;

public class ConfigServerTestUtils {
    public static final String REPO_PREFIX = "target/repos/";

    public static Repository prepareBareRemote() throws IOException {
        File remoteDir = File.createTempFile("remote", "");
        remoteDir.delete();
        remoteDir.mkdirs();
        RepositoryCache.FileKey fileKey = RepositoryCache.FileKey.exact((File)remoteDir, (FS)FS.DETECTED);
        Repository remoteRepo = fileKey.open(false);
        remoteRepo.create(true);
        return remoteRepo;
    }

    public static String prepareLocalRepo() throws IOException {
        return ConfigServerTestUtils.prepareLocalRepo("./", "target/repos", "config-repo", "target/config");
    }

    public static String prepareLocalRepo(String repoPath) throws IOException {
        return ConfigServerTestUtils.prepareLocalRepo("./", "target/repos", repoPath, "target/config");
    }

    public static String prepareLocalRepo(String baseDir, String buildDir, String repoPath, String checkoutDir) throws IOException {
        buildDir = baseDir + buildDir;
        new File(buildDir).mkdirs();
        if (!repoPath.startsWith("/")) {
            repoPath = "/" + repoPath;
        }
        if (!repoPath.endsWith("/")) {
            repoPath = repoPath + "/";
        }
        File source = new File(baseDir + "src/test/resources" + repoPath);
        File dest = new File(buildDir + repoPath);
        if (dest.exists()) {
            FileUtils.delete((File)dest, (int)3);
        }
        FileSystemUtils.copyRecursively((File)source, (File)dest);
        File dotGit = new File(buildDir + repoPath + ".git");
        File git = new File(buildDir + repoPath + "git");
        if (git.exists() && dotGit.exists()) {
            FileUtils.delete((File)dotGit, (int)1);
        }
        git.renameTo(dotGit);
        File local = new File(checkoutDir);
        if (local.exists()) {
            FileUtils.delete((File)local, (int)1);
        }
        if (!buildDir.startsWith("/")) {
            buildDir = "./" + buildDir;
        }
        return "file:" + buildDir + repoPath;
    }

    public static String prepareLocalSvnRepo(String sourceDir, String checkoutDir) throws Exception {
        File sourceDirFile = new File(sourceDir);
        sourceDirFile.mkdirs();
        File local = new File(checkoutDir);
        if (local.exists()) {
            FileUtils.delete((File)local, (int)1);
        }
        local.mkdirs();
        FileSystemUtils.copyRecursively((File)sourceDirFile, (File)local);
        return StringUtils.cleanPath((String)("file:///" + local.getAbsolutePath()));
    }

    public static String getBaseDirectory(String potentialRoot) {
        return new File(potentialRoot).exists() ? potentialRoot + "/" : "./";
    }

    public static String copyLocalRepo(String path) throws IOException {
        File dest = new File(REPO_PREFIX + path);
        FileSystemUtils.deleteRecursively((File)dest);
        FileSystemUtils.copyRecursively((File)new File("target/repos/config-repo"), (File)dest);
        return "file:./target/repos/" + path;
    }

    public static boolean deleteLocalRepo(String path) throws IOException {
        File dest = new File(REPO_PREFIX + path);
        return FileSystemUtils.deleteRecursively((File)dest);
    }

    public static Object getProperty(Environment env, String sourceNameEndsWith, String property) {
        for (PropertySource source : env.getPropertySources()) {
            if (!source.getName().endsWith(sourceNameEndsWith)) continue;
            return source.getSource().get(property);
        }
        return null;
    }
}

