/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.support;

import java.security.GeneralSecurityException;
import javax.net.ssl.HostnameVerifier;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.springframework.cloud.config.server.proxy.ProxyHostCredentialsProvider;
import org.springframework.cloud.config.server.proxy.ProxyHostProperties;
import org.springframework.cloud.config.server.proxy.SchemeBasedRoutePlanner;
import org.springframework.cloud.config.server.support.HttpEnvironmentRepositoryProperties;
import org.springframework.util.CollectionUtils;

public class HttpClientSupport {
    public static HttpClientBuilder builder(HttpEnvironmentRepositoryProperties environmentProperties) throws GeneralSecurityException {
        SSLContextBuilder sslContextBuilder = new SSLContextBuilder();
        HttpClientBuilder httpClientBuilder = HttpClients.custom();
        if (environmentProperties.isSkipSslValidation()) {
            sslContextBuilder.loadTrustMaterial(null, (certificate, authType) -> true);
            httpClientBuilder.setSSLHostnameVerifier((HostnameVerifier)new NoopHostnameVerifier());
        }
        if (!CollectionUtils.isEmpty(environmentProperties.getProxy())) {
            ProxyHostProperties httpsProxy = environmentProperties.getProxy().get((Object)ProxyHostProperties.ProxyForScheme.HTTPS);
            ProxyHostProperties httpProxy = environmentProperties.getProxy().get((Object)ProxyHostProperties.ProxyForScheme.HTTP);
            httpClientBuilder.setRoutePlanner((HttpRoutePlanner)new SchemeBasedRoutePlanner(httpsProxy, httpProxy));
            httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)new ProxyHostCredentialsProvider(httpProxy, httpsProxy));
        }
        int timeout = environmentProperties.getTimeout() * 1000;
        return httpClientBuilder.setSSLContext(sslContextBuilder.build()).setDefaultRequestConfig(RequestConfig.custom().setSocketTimeout(timeout).setConnectTimeout(timeout).build());
    }
}

