/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.support;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.config.server.support.AbstractScmAccessorProperties;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.UrlResource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.FileSystemUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractScmAccessor
implements ResourceLoaderAware {
    protected Log logger = LogFactory.getLog(this.getClass());
    private File basedir;
    private String uri;
    private ConfigurableEnvironment environment;
    private String username;
    private String password;
    private String passphrase;
    private boolean strictHostKeyChecking;
    private String[] searchPaths;
    private ResourceLoader resourceLoader = new DefaultResourceLoader();

    public AbstractScmAccessor(ConfigurableEnvironment environment) {
        this.environment = environment;
        this.basedir = this.createBaseDir();
    }

    public AbstractScmAccessor(ConfigurableEnvironment environment, AbstractScmAccessorProperties properties) {
        this.environment = environment;
        this.basedir = properties.getBasedir() == null ? this.createBaseDir() : properties.getBasedir();
        this.passphrase = properties.getPassphrase();
        this.password = properties.getPassword();
        this.searchPaths = properties.getSearchPaths();
        this.strictHostKeyChecking = properties.isStrictHostKeyChecking();
        this.uri = properties.getUri();
        this.username = properties.getUsername();
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    protected File createBaseDir() {
        try {
            final Path basedir = Files.createTempDirectory("config-repo-", new FileAttribute[0]);
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        FileSystemUtils.deleteRecursively((Path)basedir);
                    }
                    catch (IOException e) {
                        AbstractScmAccessor.this.logger.warn((Object)("Failed to delete temporary directory on exit: " + e));
                    }
                }
            });
            return basedir.toFile();
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot create temp dir", e);
        }
    }

    public ConfigurableEnvironment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(ConfigurableEnvironment environment) {
        this.environment = environment;
    }

    public void setUri(String uri) {
        while (uri.endsWith("/")) {
            uri = uri.substring(0, uri.length() - 1);
        }
        int index = uri.indexOf("://");
        if (index > 0 && !uri.substring(index + "://".length()).contains("/")) {
            uri = uri + "/";
        }
        this.uri = uri;
    }

    public String getUri() {
        return this.uri;
    }

    public void setBasedir(File basedir) {
        this.basedir = basedir.getAbsoluteFile();
    }

    public File getBasedir() {
        return this.basedir;
    }

    public void setSearchPaths(String ... searchPaths) {
        this.searchPaths = searchPaths;
    }

    public String[] getSearchPaths() {
        return this.searchPaths;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassphrase() {
        return this.passphrase;
    }

    public void setPassphrase(String passphrase) {
        this.passphrase = passphrase;
    }

    public boolean isStrictHostKeyChecking() {
        return this.strictHostKeyChecking;
    }

    public void setStrictHostKeyChecking(boolean strictHostKeyChecking) {
        this.strictHostKeyChecking = strictHostKeyChecking;
    }

    protected File getWorkingDirectory() {
        if (this.uri.startsWith("file:")) {
            try {
                return new UrlResource(StringUtils.cleanPath((String)this.uri)).getFile();
            }
            catch (Exception e) {
                throw new IllegalStateException("Cannot convert uri to file: " + this.uri);
            }
        }
        return this.basedir;
    }

    protected String[] getSearchLocations(File dir, String application, String profile, String label) {
        String[] locations = this.searchPaths;
        if (locations == null || locations.length == 0) {
            locations = AbstractScmAccessorProperties.DEFAULT_LOCATIONS;
        } else if (locations != AbstractScmAccessorProperties.DEFAULT_LOCATIONS) {
            locations = StringUtils.concatenateStringArrays((String[])AbstractScmAccessorProperties.DEFAULT_LOCATIONS, (String[])locations);
        }
        LinkedHashSet<String> output = new LinkedHashSet<String>();
        for (String location : locations) {
            String[] profiles = new String[]{profile};
            if (profile != null) {
                profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
            }
            String[] apps = new String[]{application};
            if (application != null) {
                apps = StringUtils.commaDelimitedListToStringArray((String)application);
            }
            for (String prof : profiles) {
                for (String app : apps) {
                    String value = location;
                    if (app != null) {
                        value = value.replace("{application}", app);
                    }
                    if (prof != null) {
                        value = value.replace("{profile}", prof);
                    }
                    if (label != null) {
                        value = value.replace("{label}", label);
                    }
                    if (!value.endsWith("/")) {
                        value = value + "/";
                    }
                    output.addAll(this.matchingDirectories(dir, value));
                }
            }
        }
        return output.toArray(new String[0]);
    }

    private List<String> matchingDirectories(File dir, String value) {
        ArrayList<String> output = new ArrayList<String>();
        try {
            PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver(this.resourceLoader);
            String path = new File(dir, value).toURI().toString();
            for (Resource resource : resolver.getResources(path)) {
                if (!resource.getFile().isDirectory()) continue;
                output.add(resource.getURI().toString());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return output;
    }
}

